/*
 * Decompiled with CFR 0.152.
 */
package org.raml.ramltopojo;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EcmaPattern {
    private static final Pattern ECMA_WITH_SLASHES = Pattern.compile("^/(.*)/([a-z]*)$");
    private final Pattern pattern;

    public EcmaPattern(Pattern pattern) {
        this.pattern = pattern;
    }

    public static boolean isSlashedPattern(String name) {
        return ECMA_WITH_SLASHES.matcher(name).matches();
    }

    public String asJavaPattern() {
        return this.pattern.toString();
    }

    public static EcmaPattern fromString(String ecmaPattern) {
        Matcher matcher = ECMA_WITH_SLASHES.matcher(ecmaPattern);
        if (matcher.matches()) {
            return EcmaPattern.ecmaToJavaRegexp(matcher.group(1), matcher.group(2));
        }
        return EcmaPattern.ecmaToJavaRegexp(ecmaPattern, "");
    }

    private static EcmaPattern ecmaToJavaRegexp(String ecmaPattern, String options) {
        int flags = 0;
        if (options.contains("i")) {
            flags |= 2;
        }
        if (options.contains("m")) {
            flags |= 8;
        }
        return new EcmaPattern(Pattern.compile(ecmaPattern, flags));
    }

    public int flags() {
        return this.pattern.flags();
    }
}

