/*
 * Decompiled with CFR 0.152.
 */
package org.raml.ramltopojo.extensions;

import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.WildcardTypeName;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.lang.model.element.Modifier;
import org.raml.ramltopojo.EcmaPattern;
import org.raml.ramltopojo.EventType;
import org.raml.ramltopojo.extensions.ObjectPluginContext;
import org.raml.ramltopojo.extensions.ObjectTypeHandlerPlugin;
import org.raml.v2.api.model.v10.datamodel.ObjectTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;

public class GenericJacksonAdditionalProperties
extends ObjectTypeHandlerPlugin.Helper {
    private static final ParameterizedTypeName ADDITIONAL_PROPERTIES_TYPE = ParameterizedTypeName.get(Map.class, (Type[])new Type[]{String.class, Object.class});
    private final Class<? extends Annotation> jsonAnyGetterAnnotation;
    private final Class<? extends Annotation> jsonAnySetterAnnotation;
    private final Class<? extends Annotation> jsonIgnore;

    public GenericJacksonAdditionalProperties(Class<? extends Annotation> jsonAnyGetterAnnotation, Class<? extends Annotation> jsonAnySetterAnnotation, Class<? extends Annotation> jsonIgnore) {
        this.jsonAnyGetterAnnotation = jsonAnyGetterAnnotation;
        this.jsonAnySetterAnnotation = jsonAnySetterAnnotation;
        this.jsonIgnore = jsonIgnore;
    }

    @Override
    public TypeSpec.Builder classCreated(ObjectPluginContext objectPluginContext, ObjectTypeDeclaration obj, TypeSpec.Builder typeSpec, EventType eventType) {
        if (!obj.additionalProperties().booleanValue()) {
            return typeSpec;
        }
        TypeName newSpec = objectPluginContext.createSupportClass(this.buildSpecialMap());
        if (eventType != EventType.IMPLEMENTATION) {
            typeSpec.addMethod(MethodSpec.methodBuilder((String)"getAdditionalProperties").returns((TypeName)ADDITIONAL_PROPERTIES_TYPE).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addAnnotation(this.jsonAnyGetterAnnotation).build());
            typeSpec.addMethod(MethodSpec.methodBuilder((String)"setAdditionalProperties").returns(TypeName.VOID).addParameter(ParameterSpec.builder((TypeName)ParameterizedTypeName.get(String.class), (String)"key", (Modifier[])new Modifier[0]).build()).addParameter(ParameterSpec.builder((TypeName)ParameterizedTypeName.get(Object.class), (String)"value", (Modifier[])new Modifier[0]).build()).addAnnotation(this.jsonAnySetterAnnotation).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).build());
        } else {
            typeSpec.addField(FieldSpec.builder((TypeName)ADDITIONAL_PROPERTIES_TYPE, (String)"additionalProperties", (Modifier[])new Modifier[]{Modifier.PRIVATE}).addAnnotation(AnnotationSpec.builder(this.jsonIgnore).build()).initializer(this.withProperties(newSpec, obj).build()).build());
            typeSpec.addMethod(MethodSpec.methodBuilder((String)"getAdditionalProperties").returns((TypeName)ADDITIONAL_PROPERTIES_TYPE).addModifiers(new Modifier[]{Modifier.PUBLIC}).addCode("return additionalProperties;\n", new Object[0]).addAnnotation(this.jsonAnyGetterAnnotation).build());
            typeSpec.addMethod(MethodSpec.methodBuilder((String)"setAdditionalProperties").returns(TypeName.VOID).addParameter(ParameterSpec.builder((TypeName)ParameterizedTypeName.get(String.class), (String)"key", (Modifier[])new Modifier[0]).build()).addParameter(ParameterSpec.builder((TypeName)ParameterizedTypeName.get(Object.class), (String)"value", (Modifier[])new Modifier[0]).build()).addAnnotation(this.jsonAnySetterAnnotation).addModifiers(new Modifier[]{Modifier.PUBLIC}).addCode(CodeBlock.builder().add("this.additionalProperties.put(key, value);\n", new Object[0]).build()).build());
        }
        return typeSpec;
    }

    private CodeBlock.Builder withProperties(TypeName newSpec, ObjectTypeDeclaration object) {
        ImmutableList properties = FluentIterable.from((Iterable)object.properties()).filter((Predicate)new Predicate<TypeDeclaration>(){

            public boolean apply(@Nullable TypeDeclaration property) {
                return property != null && EcmaPattern.isSlashedPattern(property.name()) && !EcmaPattern.fromString(property.name()).asJavaPattern().isEmpty();
            }
        }).toList();
        if (properties.size() == 0) {
            return CodeBlock.of((String)"new $T()", (Object[])new Object[]{newSpec}).toBuilder();
        }
        CodeBlock.Builder cb = CodeBlock.builder().beginControlFlow("new $T()", new Object[]{newSpec}).beginControlFlow("", new Object[0]);
        for (TypeDeclaration typeDeclaration : object.properties()) {
            cb.addStatement("addAcceptedPattern($T.compile($S))", new Object[]{Pattern.class, EcmaPattern.fromString(typeDeclaration.name()).asJavaPattern()});
        }
        return cb.endControlFlow().endControlFlow();
    }

    protected TypeSpec.Builder buildSpecialMap() {
        return TypeSpec.classBuilder((String)"ExcludingMap").superclass((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(HashMap.class), (TypeName[])new TypeName[]{ClassName.get(String.class), ClassName.get(Object.class)})).addField(FieldSpec.builder((TypeName)ParameterizedTypeName.get(Set.class, (Type[])new Type[]{Pattern.class}), (String)"additionalProperties", (Modifier[])new Modifier[0]).initializer(CodeBlock.builder().add(" new $T()", new Object[]{ParameterizedTypeName.get(HashSet.class, (Type[])new Type[]{Pattern.class})}).build()).build()).addMethod(MethodSpec.methodBuilder((String)"put").addParameter((TypeName)ClassName.get(String.class), "key", new Modifier[0]).addParameter((TypeName)ClassName.get(Object.class), "value", new Modifier[0]).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)TypeName.OBJECT).beginControlFlow("if ( additionalProperties.size() == 0 ) ", new Object[0]).addStatement("return super.put(key, value)", new Object[0]).endControlFlow().beginControlFlow("else", new Object[0]).addStatement("return setProperty(key, value)", new Object[0]).endControlFlow().build()).addMethod(MethodSpec.methodBuilder((String)"putAll").addParameter((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf(String.class), WildcardTypeName.subtypeOf(Object.class)}), "otherMap", new Modifier[0]).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(TypeName.VOID).addCode(CodeBlock.builder().beginControlFlow("if ( additionalProperties.size() == 0 ) ", new Object[0]).addStatement("super.putAll(otherMap)", new Object[0]).endControlFlow().beginControlFlow("else", new Object[0]).beginControlFlow("for ( String key: otherMap.keySet() )", new Object[0]).addStatement("setProperty(key, otherMap.get(key))", new Object[0]).endControlFlow().endControlFlow().build()).build()).addMethod(MethodSpec.methodBuilder((String)"addAcceptedPattern").addParameter((TypeName)ClassName.get(Pattern.class), "pattern", new Modifier[0]).addModifiers(new Modifier[]{Modifier.PROTECTED}).returns(TypeName.VOID).addCode(CodeBlock.builder().addStatement("additionalProperties.add(pattern)", new Object[0]).build()).build()).addMethod(MethodSpec.methodBuilder((String)"setProperty").addParameter((TypeName)ClassName.get(String.class), "key", new Modifier[0]).addParameter((TypeName)ClassName.get(Object.class), "value", new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE}).returns((TypeName)TypeName.OBJECT).beginControlFlow("if ( additionalProperties.size() == 0 ) ", new Object[0]).addStatement("return super.put(key, value)", new Object[0]).endControlFlow().beginControlFlow("else", new Object[0]).beginControlFlow("for ( $T p : additionalProperties)", new Object[]{Pattern.class}).beginControlFlow("if ( p.matcher(key).matches() )", new Object[0]).addStatement("return super.put(key, value)", new Object[0]).endControlFlow().endControlFlow().addStatement("throw new $T(\"property \" + key + \" is invalid according to RAML type\")", new Object[]{IllegalArgumentException.class}).endControlFlow().build()).addModifiers(new Modifier[]{Modifier.PUBLIC});
    }
}

