/*
 * Decompiled with CFR 0.152.
 */
package org.raml.ramltopojo;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.raml.ramltopojo.Annotations;
import org.raml.ramltopojo.CreationResult;
import org.raml.ramltopojo.EventType;
import org.raml.ramltopojo.GenerationContext;
import org.raml.ramltopojo.TypeAnalyserFactory;
import org.raml.ramltopojo.TypeHandler;
import org.raml.ramltopojo.TypeHandlerFactory;
import org.raml.ramltopojo.Utils;
import org.raml.ramltopojo.array.ArrayTypeHandler;
import org.raml.ramltopojo.enumeration.EnumerationTypeHandler;
import org.raml.ramltopojo.extensions.ArrayTypeHandlerPlugin;
import org.raml.ramltopojo.extensions.EnumerationTypeHandlerPlugin;
import org.raml.ramltopojo.extensions.ObjectTypeHandlerPlugin;
import org.raml.ramltopojo.extensions.ReferenceTypeHandlerPlugin;
import org.raml.ramltopojo.extensions.UnionTypeHandlerPlugin;
import org.raml.ramltopojo.nulltype.NullTypeHandler;
import org.raml.ramltopojo.object.ObjectTypeHandler;
import org.raml.ramltopojo.references.ReferenceTypeHandler;
import org.raml.ramltopojo.union.UnionTypeHandler;
import org.raml.v2.api.model.v10.api.Api;
import org.raml.v2.api.model.v10.common.Annotable;
import org.raml.v2.api.model.v10.datamodel.AnyTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.ArrayTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.BooleanTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.DateTimeOnlyTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.DateTimeTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.DateTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.FileTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.IntegerTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.NullTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.NumberTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.ObjectTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.StringTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.TimeOnlyTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.UnionTypeDeclaration;

public enum TypeDeclarationType implements TypeHandlerFactory,
TypeAnalyserFactory
{
    NULL{

        @Override
        public boolean shouldCreateInlineType(TypeDeclaration declaration) {
            return false;
        }

        @Override
        public TypeHandler createHandler(String name, TypeDeclarationType type, TypeDeclaration typeDeclaration) {
            return new NullTypeHandler(name, typeDeclaration);
        }
    }
    ,
    OBJECT{

        @Override
        public TypeHandler createHandler(String name, TypeDeclarationType type, TypeDeclaration typeDeclaration) {
            return new ObjectTypeHandler(name, (ObjectTypeDeclaration)typeDeclaration);
        }

        @Override
        public boolean shouldCreateInlineType(TypeDeclaration declaration) {
            List extended = declaration.parentTypes();
            if (extended.size() > 1) {
                return true;
            }
            ImmutableSet allExtendedProps = extended.size() == 1 && ((TypeDeclaration)extended.get(0)).name().equals("object") ? Collections.emptySet() : FluentIterable.from((Iterable)extended).filter(ObjectTypeDeclaration.class).transformAndConcat((Function)new Function<ObjectTypeDeclaration, Set<String>>(){

                @Nullable
                public Set<String> apply(@Nullable ObjectTypeDeclaration input) {
                    return TypeDeclarationType.pullNames(input);
                }
            }).toSet();
            Set typePropertyNames = TypeDeclarationType.pullNames((ObjectTypeDeclaration)declaration);
            return !Sets.difference((Set)typePropertyNames, (Set)allExtendedProps).isEmpty();
        }
    }
    ,
    ENUMERATION{

        @Override
        public TypeHandler createHandler(String name, TypeDeclarationType type, TypeDeclaration typeDeclaration) {
            return new EnumerationTypeHandler(name, typeDeclaration);
        }

        @Override
        public boolean shouldCreateInlineType(TypeDeclaration declaration) {
            return "string".equals(declaration.type()) || "number".equals(declaration.type()) || "integer".equals(declaration.type());
        }
    }
    ,
    ARRAY{

        @Override
        public TypeHandler createHandler(String name, TypeDeclarationType type, TypeDeclaration typeDeclaration) {
            ArrayTypeDeclaration arrayTypeDeclaration = (ArrayTypeDeclaration)typeDeclaration;
            return new ArrayTypeHandler(name, arrayTypeDeclaration);
        }

        @Override
        public boolean shouldCreateInlineType(TypeDeclaration declaration) {
            ArrayTypeDeclaration arrayTypeDeclaration = (ArrayTypeDeclaration)declaration;
            return Annotations.GENERATE_INLINE_ARRAY_TYPE.get((Annotable)declaration);
        }
    }
    ,
    UNION{

        @Override
        public TypeHandler createHandler(String name, TypeDeclarationType type, TypeDeclaration typeDeclaration) {
            return new UnionTypeHandler(name, (UnionTypeDeclaration)typeDeclaration);
        }

        @Override
        public boolean shouldCreateInlineType(TypeDeclaration declaration) {
            return declaration.name().contains("|") || declaration.type().contains("|");
        }
    }
    ,
    INTEGER{

        @Override
        public TypeHandler createHandler(String name, TypeDeclarationType type, TypeDeclaration typeDeclaration) {
            NumberTypeDeclaration integerTypeDeclaration = (NumberTypeDeclaration)typeDeclaration;
            if (!integerTypeDeclaration.enumValues().isEmpty()) {
                return ENUMERATION.createHandler(name, type, typeDeclaration);
            }
            TypeName typeName = (TypeName)Optional.fromNullable(properType.get(integerTypeDeclaration.format())).or((Object)TypeName.INT);
            return new ReferenceTypeHandler(typeDeclaration, Integer.class, typeName);
        }

        @Override
        public boolean shouldCreateInlineType(TypeDeclaration originalTypeDeclaration) {
            IntegerTypeDeclaration declaration = (IntegerTypeDeclaration)originalTypeDeclaration;
            if (!declaration.enumValues().isEmpty()) {
                return ENUMERATION.shouldCreateInlineType(originalTypeDeclaration);
            }
            return false;
        }
    }
    ,
    BOOLEAN{

        @Override
        public TypeHandler createHandler(String name, TypeDeclarationType type, TypeDeclaration typeDeclaration) {
            return new ReferenceTypeHandler(typeDeclaration, Boolean.class, TypeName.BOOLEAN);
        }

        @Override
        public boolean shouldCreateInlineType(TypeDeclaration declaration) {
            return false;
        }
    }
    ,
    DATE{

        @Override
        public TypeHandler createHandler(String name, TypeDeclarationType type, TypeDeclaration typeDeclaration) {
            return new ReferenceTypeHandler(typeDeclaration, Date.class, (TypeName)ClassName.get(Date.class));
        }

        @Override
        public boolean shouldCreateInlineType(TypeDeclaration declaration) {
            return false;
        }
    }
    ,
    DATETIME{

        @Override
        public TypeHandler createHandler(String name, TypeDeclarationType type, TypeDeclaration typeDeclaration) {
            return new ReferenceTypeHandler(typeDeclaration, Date.class, (TypeName)ClassName.get(Date.class));
        }

        @Override
        public boolean shouldCreateInlineType(TypeDeclaration declaration) {
            return false;
        }
    }
    ,
    TIME_ONLY{

        @Override
        public TypeHandler createHandler(String name, TypeDeclarationType type, TypeDeclaration typeDeclaration) {
            return new ReferenceTypeHandler(typeDeclaration, Date.class, (TypeName)ClassName.get(Date.class));
        }

        @Override
        public boolean shouldCreateInlineType(TypeDeclaration declaration) {
            return false;
        }
    }
    ,
    DATETIME_ONLY{

        @Override
        public TypeHandler createHandler(String name, TypeDeclarationType type, TypeDeclaration typeDeclaration) {
            return new ReferenceTypeHandler(typeDeclaration, Date.class, (TypeName)ClassName.get(Date.class));
        }

        @Override
        public boolean shouldCreateInlineType(TypeDeclaration declaration) {
            return false;
        }
    }
    ,
    NUMBER{

        @Override
        public TypeHandler createHandler(String name, TypeDeclarationType type, TypeDeclaration typeDeclaration) {
            NumberTypeDeclaration integerTypeDeclaration = (NumberTypeDeclaration)typeDeclaration;
            if (!integerTypeDeclaration.enumValues().isEmpty()) {
                return ENUMERATION.createHandler(name, type, typeDeclaration);
            }
            TypeName typeName = (TypeName)Optional.fromNullable(properType.get(integerTypeDeclaration.format())).or((Object)ClassName.get(Number.class));
            return new ReferenceTypeHandler(typeDeclaration, Number.class, typeName);
        }

        @Override
        public boolean shouldCreateInlineType(TypeDeclaration originalTypeDeclaration) {
            NumberTypeDeclaration declaration = (NumberTypeDeclaration)originalTypeDeclaration;
            if (!declaration.enumValues().isEmpty()) {
                return ENUMERATION.shouldCreateInlineType(originalTypeDeclaration);
            }
            return false;
        }
    }
    ,
    STRING{

        @Override
        public TypeHandler createHandler(String name, TypeDeclarationType type, TypeDeclaration typeDeclaration) {
            StringTypeDeclaration declaration = (StringTypeDeclaration)typeDeclaration;
            if (!declaration.enumValues().isEmpty()) {
                return ENUMERATION.createHandler(name, type, typeDeclaration);
            }
            return new ReferenceTypeHandler(typeDeclaration, String.class, (TypeName)ClassName.get(String.class));
        }

        @Override
        public boolean shouldCreateInlineType(TypeDeclaration originalTypeDeclaration) {
            StringTypeDeclaration declaration = (StringTypeDeclaration)originalTypeDeclaration;
            if (!declaration.enumValues().isEmpty()) {
                return ENUMERATION.shouldCreateInlineType(originalTypeDeclaration);
            }
            return false;
        }
    }
    ,
    ANY{

        @Override
        public TypeHandler createHandler(String name, TypeDeclarationType type, TypeDeclaration typeDeclaration) {
            return new ReferenceTypeHandler(typeDeclaration, Object.class, (TypeName)ClassName.get(Object.class));
        }

        @Override
        public boolean shouldCreateInlineType(TypeDeclaration declaration) {
            return false;
        }
    }
    ,
    FILE{

        @Override
        public TypeHandler createHandler(String name, TypeDeclarationType type, TypeDeclaration typeDeclaration) {
            return new ReferenceTypeHandler(typeDeclaration, File.class, (TypeName)ClassName.get(File.class));
        }

        @Override
        public boolean shouldCreateInlineType(TypeDeclaration declaration) {
            return false;
        }
    };

    private static Map<String, TypeName> properType;
    private static Map<Class, TypeDeclarationType> ramlToType;

    private static Set<String> pullNames(ObjectTypeDeclaration extending) {
        return FluentIterable.from((Iterable)extending.properties()).transform((Function)new Function<TypeDeclaration, String>(){

            @Nullable
            public String apply(@Nullable TypeDeclaration input) {
                return input.name();
            }
        }).toSet();
    }

    public abstract boolean shouldCreateInlineType(TypeDeclaration var1);

    public static Optional<CreationResult> createType(TypeDeclaration typeDeclaration, GenerationContext context) {
        TypeDeclarationType typeDeclarationType = ramlToType.get(Utils.declarationType(typeDeclaration));
        TypeHandler handler = typeDeclarationType.createHandler(typeDeclaration.name(), typeDeclarationType, typeDeclaration);
        ClassName intf = handler.javaClassName(context, EventType.INTERFACE);
        ClassName impl = handler.javaClassName(context, EventType.IMPLEMENTATION);
        CreationResult creationResult = new CreationResult(context.defaultPackage(), intf, impl);
        context.newExpectedType(typeDeclaration.name(), creationResult);
        context.setupTypeHierarchy(typeDeclaration);
        return handler.create(context, creationResult);
    }

    public static Optional<CreationResult> createNamedType(String name, TypeDeclaration typeDeclaration, GenerationContext context) {
        TypeDeclarationType typeDeclarationType = ramlToType.get(Utils.declarationType(typeDeclaration));
        TypeHandler handler = typeDeclarationType.createHandler(name, typeDeclarationType, typeDeclaration);
        ClassName intf = handler.javaClassName(context, EventType.INTERFACE);
        ClassName impl = handler.javaClassName(context, EventType.IMPLEMENTATION);
        CreationResult creationResult = new CreationResult(context.defaultPackage(), intf, impl);
        context.newExpectedType(name, creationResult);
        context.setupTypeHierarchy(typeDeclaration);
        return handler.create(context, creationResult);
    }

    public static Optional<CreationResult> createInlineType(ClassName containingClassName, ClassName containingImplementation, String name, TypeDeclaration typeDeclaration, GenerationContext context) {
        TypeDeclarationType typeDeclarationType = ramlToType.get(Utils.declarationType(typeDeclaration));
        TypeHandler handler = typeDeclarationType.createHandler(name, typeDeclarationType, typeDeclaration);
        ClassName intf = handler.javaClassName(new InlineGenerationContext(containingClassName, containingClassName, context), EventType.INTERFACE);
        ClassName impl = handler.javaClassName(new InlineGenerationContext(containingClassName, containingImplementation, context), EventType.IMPLEMENTATION);
        CreationResult preCreationResult = new CreationResult("", intf, impl);
        return handler.create(context, preCreationResult);
    }

    public static TypeName calculateTypeName(String name, TypeDeclaration typeDeclaration, GenerationContext context, EventType eventType) {
        TypeDeclarationType typeDeclarationType = ramlToType.get(Utils.declarationType(typeDeclaration));
        TypeHandler handler = typeDeclarationType.createHandler(name, typeDeclarationType, typeDeclaration);
        TypeName typeName = handler.javaClassReference(context, eventType);
        context.setupTypeHierarchy(typeDeclaration);
        return typeName;
    }

    public static boolean isNewInlineType(TypeDeclaration declaration) {
        return ramlToType.get(Utils.declarationType(declaration)).shouldCreateInlineType(declaration);
    }

    static {
        properType = ImmutableMap.builder().put((Object)"float", (Object)TypeName.FLOAT).put((Object)"double", (Object)TypeName.DOUBLE).put((Object)"int8", (Object)TypeName.BYTE).put((Object)"int16", (Object)TypeName.SHORT).put((Object)"int32", (Object)TypeName.INT).put((Object)"int64", (Object)TypeName.LONG).put((Object)"int", (Object)TypeName.INT).build();
        ramlToType = ImmutableMap.builder().put(ObjectTypeDeclaration.class, (Object)OBJECT).put(ArrayTypeDeclaration.class, (Object)ARRAY).put(UnionTypeDeclaration.class, (Object)UNION).put(DateTimeOnlyTypeDeclaration.class, (Object)DATETIME_ONLY).put(IntegerTypeDeclaration.class, (Object)INTEGER).put(BooleanTypeDeclaration.class, (Object)BOOLEAN).put(TimeOnlyTypeDeclaration.class, (Object)TIME_ONLY).put(DateTimeTypeDeclaration.class, (Object)DATETIME).put(DateTypeDeclaration.class, (Object)DATE).put(NumberTypeDeclaration.class, (Object)NUMBER).put(StringTypeDeclaration.class, (Object)STRING).put(FileTypeDeclaration.class, (Object)FILE).put(AnyTypeDeclaration.class, (Object)ANY).put(NullTypeDeclaration.class, (Object)NULL).build();
    }

    private static class InlineGenerationContext
    implements GenerationContext {
        private final ClassName containingDeclaration;
        private final ClassName containingImplementation;
        private final GenerationContext context;

        public InlineGenerationContext(ClassName containingDeclaration, ClassName containingImplementation, GenerationContext context) {
            this.containingDeclaration = containingDeclaration;
            this.containingImplementation = containingImplementation;
            this.context = context;
        }

        @Override
        public void createSupportTypes(String rootDirectory) throws IOException {
            this.context.createSupportTypes(rootDirectory);
        }

        @Override
        public TypeName createSupportClass(TypeSpec.Builder newSupportType) {
            return this.context.createSupportClass(newSupportType);
        }

        @Override
        public CreationResult findCreatedType(String typeName, TypeDeclaration ramlType) {
            return this.context.findCreatedType(typeName, ramlType);
        }

        @Override
        public String defaultPackage() {
            return "";
        }

        @Override
        public void newExpectedType(String name, CreationResult creationResult) {
        }

        @Override
        public void createTypes(String rootDirectory) throws IOException {
        }

        @Override
        public ObjectTypeHandlerPlugin pluginsForObjects(TypeDeclaration ... typeDeclarations) {
            return this.context.pluginsForObjects(typeDeclarations);
        }

        @Override
        public EnumerationTypeHandlerPlugin pluginsForEnumerations(TypeDeclaration ... typeDeclarations) {
            return this.context.pluginsForEnumerations(typeDeclarations);
        }

        @Override
        public UnionTypeHandlerPlugin pluginsForUnions(TypeDeclaration ... typeDeclarations) {
            return this.context.pluginsForUnions(typeDeclarations);
        }

        @Override
        public ArrayTypeHandlerPlugin pluginsForArrays(TypeDeclaration ... typeDeclarations) {
            return this.context.pluginsForArrays(typeDeclarations);
        }

        @Override
        public Api api() {
            return this.context.api();
        }

        @Override
        public Set<String> childClasses(String ramlTypeName) {
            return this.context.childClasses(ramlTypeName);
        }

        @Override
        public ClassName buildDefaultClassName(String name, EventType eventType) {
            if (eventType == EventType.INTERFACE) {
                return this.containingDeclaration.nestedClass(name);
            }
            return this.containingImplementation.nestedClass(name);
        }

        @Override
        public ReferenceTypeHandlerPlugin pluginsForReferences(TypeDeclaration ... typeDeclarations) {
            return this.context.pluginsForReferences(typeDeclarations);
        }

        @Override
        public void setupTypeHierarchy(TypeDeclaration typeDeclaration) {
            this.context.setupTypeHierarchy(typeDeclaration);
        }
    }
}

