/*
 * Decompiled with CFR 0.152.
 */
package org.raml.ramltopojo.extensions.jsr303;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.TypeName;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.raml.ramltopojo.EcmaPattern;
import org.raml.ramltopojo.extensions.jsr303.AnnotationAdder;
import org.raml.v2.api.model.v10.datamodel.ArrayTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.NumberTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.ObjectTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.StringTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.UnionTypeDeclaration;

public class FacetValidation {
    public static void addFacetsForAll(AnnotationAdder typeSpec, TypeDeclaration typeDeclaration) {
        if (typeDeclaration.required() != null && typeDeclaration.required().booleanValue()) {
            typeSpec.addAnnotation(AnnotationSpec.builder(NotNull.class).build());
        }
    }

    public static void addAnnotations(TypeDeclaration typeDeclaration, AnnotationAdder adder) {
        FacetValidation.addFacetsForAll(adder, typeDeclaration);
        if (typeDeclaration instanceof NumberTypeDeclaration) {
            FacetValidation.addFacetsForNumbers(adder, (NumberTypeDeclaration)typeDeclaration);
            return;
        }
        if (typeDeclaration instanceof StringTypeDeclaration) {
            FacetValidation.addFacetsForString(adder, (StringTypeDeclaration)typeDeclaration);
        }
        if (typeDeclaration instanceof ArrayTypeDeclaration) {
            FacetValidation.addFacetsForArray(adder, (ArrayTypeDeclaration)typeDeclaration);
        }
        if (FacetValidation.isFieldFromBuiltType(typeDeclaration)) {
            FacetValidation.addFacetsForBuilt(adder);
        }
    }

    public static void addFacetsForArray(AnnotationAdder fieldSpec, ArrayTypeDeclaration typeDeclaration) {
        if (FacetValidation.isFieldFromBuiltType(typeDeclaration.items())) {
            fieldSpec.addAnnotation(Valid.class);
        }
        AnnotationSpec.Builder minMax = null;
        if (typeDeclaration.minItems() != null) {
            minMax = AnnotationSpec.builder(Size.class).addMember("min", "$L", new Object[]{typeDeclaration.minItems()});
        }
        if (typeDeclaration.maxItems() != null) {
            if (minMax == null) {
                minMax = AnnotationSpec.builder(Size.class).addMember("max", "$L", new Object[]{typeDeclaration.maxItems()});
            } else {
                minMax.addMember("max", "$L", new Object[]{typeDeclaration.maxItems()});
            }
        }
        if (minMax != null) {
            fieldSpec.addAnnotation(minMax.build());
        }
    }

    public static void addFacetsForString(AnnotationAdder typeSpec, StringTypeDeclaration typeDeclaration) {
        AnnotationSpec.Builder minMax = null;
        if (typeDeclaration.minLength() != null) {
            minMax = AnnotationSpec.builder(Size.class).addMember("min", "$L", new Object[]{typeDeclaration.minLength()});
        }
        if (typeDeclaration.maxLength() != null) {
            if (minMax == null) {
                minMax = AnnotationSpec.builder(Size.class).addMember("max", "$L", new Object[]{typeDeclaration.maxLength()});
            } else {
                minMax.addMember("max", "$L", new Object[]{typeDeclaration.maxLength()});
            }
        }
        if (minMax != null) {
            typeSpec.addAnnotation(minMax.build());
        }
        if (typeDeclaration.pattern() != null) {
            typeSpec.addAnnotation(AnnotationSpec.builder(Pattern.class).addMember("regexp", "$S", new Object[]{EcmaPattern.fromString(typeDeclaration.pattern()).asJavaPattern()}).build());
        }
    }

    public static void addFacetsForNumbers(AnnotationAdder typeSpec, NumberTypeDeclaration typeDeclaration) {
        if (typeDeclaration.minimum() != null && FacetValidation.isInteger(typeSpec.typeName())) {
            typeSpec.addAnnotation(AnnotationSpec.builder(Min.class).addMember("value", "$L", new Object[]{typeDeclaration.minimum().intValue()}).build());
        }
        if (typeDeclaration.maximum() != null && FacetValidation.isInteger(typeSpec.typeName())) {
            typeSpec.addAnnotation(AnnotationSpec.builder(Max.class).addMember("value", "$L", new Object[]{typeDeclaration.maximum().intValue()}).build());
        }
    }

    public static void addFacetsForBuilt(AnnotationAdder fieldSpec) {
        fieldSpec.addAnnotation(Valid.class);
    }

    public static boolean isFieldFromBuiltType(TypeDeclaration typeDeclaration) {
        return typeDeclaration instanceof ObjectTypeDeclaration || typeDeclaration instanceof UnionTypeDeclaration;
    }

    private static boolean isInteger(TypeName type) {
        return type.box().toString().equals(Integer.class.getName()) || type.box().toString().equals(Short.class.getName()) || type.box().toString().equals(Byte.class.getName()) || type.box().toString().equals(BigDecimal.class.getName()) || type.box().toString().equals(Long.class.getName()) || type.box().toString().equals(BigInteger.class.getName());
    }
}

