/*
 * Decompiled with CFR 0.152.
 */
package org.raml.ramltopojo.extensions.jackson2;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.lang.reflect.Type;
import java.sql.Date;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.lang.model.element.Modifier;
import org.raml.ramltopojo.EventType;
import org.raml.ramltopojo.GenerationException;
import org.raml.ramltopojo.Names;
import org.raml.ramltopojo.extensions.UnionPluginContext;
import org.raml.ramltopojo.extensions.UnionTypeHandlerPlugin;
import org.raml.ramltopojo.union.UnionTypesHelper;
import org.raml.v2.api.model.v10.datamodel.AnyTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.ArrayTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.BooleanTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.DateTimeOnlyTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.DateTimeTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.DateTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.FileTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.IntegerTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.NullTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.NumberTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.ObjectTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.StringTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.TimeOnlyTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.UnionTypeDeclaration;

public class JacksonUnionExtension
extends UnionTypeHandlerPlugin.Helper {
    @Override
    public ClassName className(UnionPluginContext unionPluginContext, UnionTypeDeclaration ramlType, ClassName currentSuggestion, EventType eventType) {
        return currentSuggestion;
    }

    @Override
    public TypeSpec.Builder classCreated(UnionPluginContext unionPluginContext, UnionTypeDeclaration ramlType, TypeSpec.Builder incoming, EventType eventType) {
        ClassName deserializer = ClassName.get((String)"", (String)unionPluginContext.creationResult().getJavaName(EventType.INTERFACE).simpleName(), (String[])new String[]{Names.typeName("deserializer")});
        ClassName serializer = ClassName.get((String)"", (String)unionPluginContext.creationResult().getJavaName(EventType.INTERFACE).simpleName(), (String[])new String[]{Names.typeName("serializer")});
        this.createSerializer(unionPluginContext, serializer, ramlType, incoming, eventType);
        this.createDeserializer(unionPluginContext, deserializer, ramlType, incoming, eventType);
        incoming.addAnnotation(AnnotationSpec.builder(JsonDeserialize.class).addMember("using", "$T.class", new Object[]{deserializer}).build());
        incoming.addAnnotation(AnnotationSpec.builder(JsonSerialize.class).addMember("using", "$T.class", new Object[]{serializer}).build());
        return incoming;
    }

    private void createSerializer(UnionPluginContext unionPluginContext, ClassName serializerName, UnionTypeDeclaration union, TypeSpec.Builder typeBuilder, EventType eventType) {
        if (eventType == EventType.IMPLEMENTATION) {
            return;
        }
        ClassName typeBuilderName = ClassName.get((String)"", (String)typeBuilder.build().name, (String[])new String[0]);
        TypeSpec.Builder builder = TypeSpec.classBuilder((ClassName)serializerName).addModifiers(new Modifier[]{Modifier.STATIC, Modifier.PUBLIC}).superclass((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(StdSerializer.class), (TypeName[])new TypeName[]{typeBuilderName})).addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("super($T.class)", new Object[]{typeBuilderName}).build()).addField(FieldSpec.builder((TypeName)TypeName.LONG, (String)"serialVersionUID", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL, Modifier.STATIC}).initializer("1L", new Object[0]).build());
        MethodSpec.Builder serialize = MethodSpec.methodBuilder((String)"serialize").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ParameterSpec.builder((TypeName)typeBuilderName, (String)"object", (Modifier[])new Modifier[0]).build()).addParameter(ParameterSpec.builder((TypeName)ClassName.get(JsonGenerator.class), (String)"jsonGenerator", (Modifier[])new Modifier[0]).build()).addParameter(ParameterSpec.builder((TypeName)ClassName.get(SerializerProvider.class), (String)"jsonSerializerProvider", (Modifier[])new Modifier[0]).build()).addException(IOException.class).addException(JsonProcessingException.class);
        for (TypeDeclaration typeDeclaration : union.of()) {
            String name = this.prettyName(typeDeclaration, unionPluginContext);
            String isMethod = Names.methodName("is", name);
            String getMethod = Names.methodName("get", name);
            serialize.beginControlFlow("if ( object." + isMethod + "())", new Object[0]);
            if (typeDeclaration instanceof DateTypeDeclaration) {
                serialize.addStatement("new $T().setDateFormat(new $T($S)).writeValue(jsonGenerator, object." + getMethod + "())", new Object[]{ObjectMapper.class, SimpleDateFormat.class, "yyyy-mm-dd"});
            } else if (typeDeclaration instanceof TimeOnlyTypeDeclaration) {
                serialize.addStatement("new $T().setDateFormat(new $T($S)).writeValue(jsonGenerator, object." + getMethod + "())", new Object[]{ObjectMapper.class, SimpleDateFormat.class, "hh:mm:ss"});
            } else if (typeDeclaration instanceof DateTimeOnlyTypeDeclaration) {
                serialize.addStatement("new $T().setDateFormat(new $T($S)).writeValue(jsonGenerator, object." + getMethod + "())", new Object[]{ObjectMapper.class, SimpleDateFormat.class, "yyyy-MM-dd'T'HH:mm:ss"});
            } else if (typeDeclaration instanceof DateTimeTypeDeclaration) {
                if (Objects.equals("rfc2616", ((DateTimeTypeDeclaration)typeDeclaration).format())) {
                    serialize.addStatement("new $T().setDateFormat(new $T($S)).writeValue(jsonGenerator, object." + getMethod + "())", new Object[]{ObjectMapper.class, SimpleDateFormat.class, "EEE, dd MMM yyyy HH:mm:ss z"});
                } else {
                    serialize.addStatement("new $T().setDateFormat(new $T($S)).writeValue(jsonGenerator, object." + getMethod + "())", new Object[]{ObjectMapper.class, SimpleDateFormat.class, "yyyy-MM-dd'T'HH:mm:ssZ"});
                }
            } else {
                serialize.addStatement("jsonGenerator.writeObject(object." + getMethod + "())", new Object[0]);
            }
            serialize.addStatement("return", new Object[0]);
            serialize.endControlFlow();
        }
        serialize.addStatement("throw new $T($S + object)", new Object[]{IOException.class, "Can't figure out type of object"});
        builder.addMethod(serialize.build());
        typeBuilder.addType(builder.build());
    }

    private void createDeserializer(UnionPluginContext unionPluginContext, ClassName serializerName, UnionTypeDeclaration union, TypeSpec.Builder typeBuilder, EventType eventType) {
        if (eventType == EventType.IMPLEMENTATION) {
            return;
        }
        ClassName typeBuilderName = ClassName.get((String)"", (String)typeBuilder.build().name, (String[])new String[0]);
        TypeSpec.Builder builder = TypeSpec.classBuilder((ClassName)serializerName).addModifiers(new Modifier[]{Modifier.STATIC, Modifier.PUBLIC}).superclass((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(StdDeserializer.class), (TypeName[])new TypeName[]{typeBuilderName})).addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("super($T.class)", new Object[]{typeBuilderName}).build()).addField(FieldSpec.builder((TypeName)TypeName.LONG, (String)"serialVersionUID", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL, Modifier.STATIC}).initializer("1L", new Object[0]).build());
        MethodSpec.Builder deserialize = MethodSpec.methodBuilder((String)"deserialize").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ParameterSpec.builder((TypeName)ClassName.get(JsonParser.class), (String)"jp", (Modifier[])new Modifier[0]).build()).addParameter(ParameterSpec.builder((TypeName)ClassName.get(DeserializationContext.class), (String)"jsonContext", (Modifier[])new Modifier[0]).build()).addException(IOException.class).addException(JsonProcessingException.class).returns((TypeName)typeBuilderName).addStatement("$T node = jp.getCodec().readTree(jp)", new Object[]{JsonNode.class});
        boolean dateValidation = false;
        boolean objectValidation = false;
        boolean nullMethod = false;
        for (TypeDeclaration typeDeclaration : UnionTypesHelper.sortByPriority(union.of())) {
            TypeName typeName = unionPluginContext.findType(typeDeclaration.name(), typeDeclaration).box();
            if (typeDeclaration instanceof NullTypeDeclaration) {
                deserialize.beginControlFlow("if (node.isNull())", new Object[0]);
                deserialize.addStatement("return new $T(null)", new Object[]{unionPluginContext.creationResult().getJavaName(EventType.IMPLEMENTATION)});
                deserialize.endControlFlow();
                if (nullMethod) continue;
                builder.addMethod(MethodSpec.methodBuilder((String)"getNullValue").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ParameterSpec.builder((TypeName)ClassName.get(DeserializationContext.class), (String)"deserializationContext", (Modifier[])new Modifier[0]).build()).returns((TypeName)typeBuilderName).addStatement("return new $T(null)", new Object[]{unionPluginContext.creationResult().getJavaName(EventType.IMPLEMENTATION)}).build());
                nullMethod = true;
                continue;
            }
            if (typeDeclaration instanceof BooleanTypeDeclaration) {
                deserialize.beginControlFlow("if (node.isBoolean())", new Object[0]);
                deserialize.addStatement("return new $T(node.asBoolean())", new Object[]{unionPluginContext.creationResult().getJavaName(EventType.IMPLEMENTATION)});
                deserialize.endControlFlow();
                continue;
            }
            if (typeDeclaration instanceof IntegerTypeDeclaration) {
                if (typeName.box().equals((Object)TypeName.LONG.box())) {
                    deserialize.beginControlFlow("if (node.isLong())", new Object[0]);
                    deserialize.addStatement("return new $T(node.asLong())", new Object[]{unionPluginContext.creationResult().getJavaName(EventType.IMPLEMENTATION)});
                    deserialize.endControlFlow();
                    continue;
                }
                if (typeName.box().equals((Object)TypeName.INT.box())) {
                    deserialize.beginControlFlow("if (node.isInt())", new Object[0]);
                    deserialize.addStatement("return new $T(node.asInt())", new Object[]{unionPluginContext.creationResult().getJavaName(EventType.IMPLEMENTATION)});
                    deserialize.endControlFlow();
                    continue;
                }
                if (typeName.box().equals((Object)TypeName.SHORT.box())) {
                    deserialize.beginControlFlow("if (node.isShort())", new Object[0]);
                    deserialize.addStatement("return new $T(jp.getCodec().treeToValue(node, $T.class)", new Object[]{unionPluginContext.creationResult().getJavaName(EventType.IMPLEMENTATION), typeName});
                    deserialize.endControlFlow();
                    continue;
                }
                throw new GenerationException("Unknown integer type");
            }
            if (typeDeclaration instanceof StringTypeDeclaration) {
                deserialize.beginControlFlow("if (node.isTextual())", new Object[0]);
                deserialize.addStatement("return new $T(node.asText())", new Object[]{unionPluginContext.creationResult().getJavaName(EventType.IMPLEMENTATION)});
                deserialize.endControlFlow();
                continue;
            }
            if (typeDeclaration instanceof NumberTypeDeclaration) {
                deserialize.beginControlFlow("if (node.isNumber())", new Object[0]);
                deserialize.addStatement("return new $T(jp.getCodec().treeToValue(node, $T.class))", new Object[]{unionPluginContext.creationResult().getJavaName(EventType.IMPLEMENTATION), Number.class});
                deserialize.endControlFlow();
                continue;
            }
            if (typeDeclaration instanceof DateTypeDeclaration) {
                dateValidation = true;
                this.buildDateDeserialize(unionPluginContext, deserialize, "yyyy-mm-dd");
                continue;
            }
            if (typeDeclaration instanceof TimeOnlyTypeDeclaration) {
                dateValidation = true;
                this.buildDateDeserialize(unionPluginContext, deserialize, "hh:mm:ss");
                continue;
            }
            if (typeDeclaration instanceof DateTimeOnlyTypeDeclaration) {
                dateValidation = true;
                this.buildDateDeserialize(unionPluginContext, deserialize, "yyyy-MM-dd'T'HH:mm:ss");
                continue;
            }
            if (typeDeclaration instanceof DateTimeTypeDeclaration) {
                dateValidation = true;
                if (Objects.equals("rfc2616", ((DateTimeTypeDeclaration)typeDeclaration).format())) {
                    this.buildDateDeserialize(unionPluginContext, deserialize, "EEE, dd MMM yyyy HH:mm:ss z");
                    continue;
                }
                this.buildDateDeserialize(unionPluginContext, deserialize, "yyyy-MM-dd'T'HH:mm:ssZ");
                continue;
            }
            if (typeDeclaration instanceof ArrayTypeDeclaration) {
                ArrayTypeDeclaration arrayTypeDeclaration = (ArrayTypeDeclaration)typeDeclaration;
                TypeName arrayType = unionPluginContext.findType(arrayTypeDeclaration.name(), (TypeDeclaration)arrayTypeDeclaration).box();
                deserialize.beginControlFlow("if (node.isArray())", new Object[0]);
                deserialize.addStatement("return new $T(jp.getCodec().treeToValue(node, $T[].class))", new Object[]{unionPluginContext.creationResult().getJavaName(EventType.IMPLEMENTATION), arrayType});
                deserialize.endControlFlow();
                continue;
            }
            if (typeDeclaration instanceof ObjectTypeDeclaration) {
                objectValidation = true;
                ObjectTypeDeclaration otd = (ObjectTypeDeclaration)typeDeclaration;
                List names = Lists.transform((List)otd.properties(), (Function)new Function<TypeDeclaration, String>(){

                    @Nullable
                    public String apply(@Nullable TypeDeclaration input) {
                        return "\"" + input.name() + "\"";
                    }
                });
                if (otd.discriminator() != null) {
                    ClassName unionPossibility = unionPluginContext.unionClass(typeDeclaration).getJavaName(EventType.INTERFACE);
                    deserialize.beginControlFlow("if (node.isObject() && isValidObject(node, $T.asList($L)) && $T.equals(node.path($S).asText(), $S))", new Object[]{Arrays.class, Joiner.on((String)",").join((Iterable)names), Objects.class, otd.discriminator(), Optional.ofNullable(otd.discriminatorValue()).orElse(otd.name())});
                    deserialize.addStatement("return new $T(($T)jp.getCodec().treeToValue(node, $T.class))", new Object[]{unionPluginContext.creationResult().getJavaName(EventType.IMPLEMENTATION), unionPossibility, unionPluginContext.unionClass(this.findParentType(typeDeclaration)).getJavaName(EventType.INTERFACE)});
                    deserialize.endControlFlow();
                    continue;
                }
                deserialize.beginControlFlow("if (node.isObject() && isValidObject(node, $T.asList($L)))", new Object[]{Arrays.class, Joiner.on((String)",").join((Iterable)names)});
                deserialize.addStatement("return new $T(jp.getCodec().treeToValue(node, $T.class))", new Object[]{unionPluginContext.creationResult().getJavaName(EventType.IMPLEMENTATION), typeName});
                deserialize.endControlFlow();
                continue;
            }
            if (typeDeclaration instanceof AnyTypeDeclaration) {
                throw new GenerationException("Type 'any' within a union is not supported yet");
            }
            if (typeDeclaration instanceof UnionTypeDeclaration) {
                throw new GenerationException("Type 'union' within a union is not supported yet");
            }
            if (typeDeclaration instanceof FileTypeDeclaration) {
                throw new GenerationException("Type 'file' within a union is not supported yet");
            }
            throw new GenerationException("Type 'unkown' within a union is not supported yet");
        }
        if (dateValidation) {
            this.buildDateValidation(builder);
        }
        if (objectValidation) {
            this.buildObjectValidation(builder);
        }
        deserialize.addStatement("throw new $T($S + node)", new Object[]{IOException.class, "Can't figure out type of object "});
        builder.addMethod(deserialize.build());
        typeBuilder.addType(builder.build());
    }

    private TypeDeclaration findParentType(TypeDeclaration typeDeclaration) {
        if (typeDeclaration instanceof ObjectTypeDeclaration) {
            ObjectTypeDeclaration otd = (ObjectTypeDeclaration)typeDeclaration;
            return otd.parentTypes().size() > 0 ? (TypeDeclaration)otd.parentTypes().get(0) : otd;
        }
        return typeDeclaration;
    }

    private void buildDateDeserialize(UnionPluginContext unionPluginContext, MethodSpec.Builder deserialize, String dateFormat) {
        deserialize.beginControlFlow("if (node.isTextual() && isValidDate(node.asText(), new $T($S)))", new Object[]{SimpleDateFormat.class, dateFormat});
        deserialize.addStatement("$T mapper = new $T()", new Object[]{ObjectMapper.class, ObjectMapper.class});
        deserialize.addStatement("mapper.setDateFormat(new $T($S))", new Object[]{SimpleDateFormat.class, dateFormat});
        deserialize.addStatement("return new $T(mapper.treeToValue(node, $T.class))", new Object[]{unionPluginContext.creationResult().getJavaName(EventType.IMPLEMENTATION), Date.class});
        deserialize.endControlFlow();
    }

    private void buildDateValidation(TypeSpec.Builder builder) {
        MethodSpec.Builder spec = MethodSpec.methodBuilder((String)"isValidDate").addParameter((TypeName)ClassName.get(String.class), "value", new Modifier[0]).addParameter((TypeName)ClassName.get(DateFormat.class), "format", new Modifier[0]);
        spec.beginControlFlow("try", new Object[0]);
        spec.addStatement("return format.parse(value) != null", new Object[0]);
        spec.endControlFlow();
        spec.beginControlFlow("catch ($T e)", new Object[]{ParseException.class});
        spec.addStatement("return false", new Object[0]);
        spec.endControlFlow();
        spec.addModifiers(new Modifier[]{Modifier.PRIVATE}).returns(TypeName.BOOLEAN);
        builder.addMethod(spec.build());
    }

    private void buildObjectValidation(TypeSpec.Builder builder) {
        MethodSpec.Builder spec = MethodSpec.methodBuilder((String)"isValidObject").addParameter((TypeName)ClassName.get(JsonNode.class), "node", new Modifier[0]).addParameter((TypeName)ParameterizedTypeName.get(List.class, (Type[])new Type[]{String.class}), "keys", new Modifier[0]);
        spec.addStatement("$T<$T> list = new $T<>()", new Object[]{List.class, String.class, ArrayList.class});
        spec.addStatement("$T<$T> fieldIterator = node.fieldNames()", new Object[]{Iterator.class, String.class});
        spec.addStatement("while (fieldIterator.hasNext()) { list.add(fieldIterator.next()); }", new Object[0]);
        spec.addStatement("return list.containsAll(keys)", new Object[0]);
        spec.addModifiers(new Modifier[]{Modifier.PRIVATE}).returns(TypeName.BOOLEAN);
        builder.addMethod(spec.build());
    }

    private String prettyName(TypeDeclaration type, UnionPluginContext unionPluginContext) {
        if (type.type() == null) {
            return type instanceof NullTypeDeclaration ? "nil" : this.shorten(unionPluginContext.findType(type.name(), type).box());
        }
        return type.name();
    }

    private String shorten(TypeName typeName) {
        if (!(typeName instanceof ClassName)) {
            throw new GenerationException(typeName + this.toString() + " cannot be shortened reasonably");
        }
        return ((ClassName)typeName).simpleName();
    }
}

