/*
 * Decompiled with CFR 0.152.
 */
package org.raml.yagi.framework.util;

import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.raml.yagi.framework.util.DateType;

public class DateUtils {
    private static DateTimeFormatter timeOnlyFormatter = DateTimeFormat.forPattern((String)"HH:mm:ss");
    private static DateTimeFormatter dateOnlyFormatter = DateTimeFormat.forPattern((String)"YYYY-MM-DD");
    private static DateTimeFormatter dateTimeOnlyFormatter = DateTimeFormat.forPattern((String)"YYYY-MM-DD'T'HH:mm:ss");
    private static DateTimeFormatter rfc2616Formatter = DateTimeFormat.forPattern((String)"EEE, dd MMM yyyy HH:mm:ss zzz");
    private static DateTimeFormatter rfc3339Formatter = ISODateTimeFormat.dateTimeParser();

    public static boolean isValidDate(String date, DateType format, String rfc) {
        try {
            switch (format) {
                case date_only: {
                    dateOnlyFormatter.parseLocalDate(date);
                    break;
                }
                case time_only: {
                    timeOnlyFormatter.parseLocalTime(date);
                    break;
                }
                case datetime_only: {
                    dateTimeOnlyFormatter.parseLocalDateTime(date);
                    break;
                }
                case datetime: {
                    if (rfc != null && "rfc2616".equals(rfc)) {
                        rfc2616Formatter.parseLocalDateTime(date);
                        break;
                    }
                    rfc3339Formatter.parseLocalDateTime(date);
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

