/*
 * Decompiled with CFR 0.152.
 */
package es.uam.eps.ir.ranksys.diversity.binom;

import es.uam.eps.ir.ranksys.core.feature.FeatureData;
import es.uam.eps.ir.ranksys.core.model.UserModel;
import es.uam.eps.ir.ranksys.core.preference.PreferenceData;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleOpenHashMap;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.math3.distribution.BinomialDistribution;
import org.jooq.lambda.tuple.Tuple2;

public class BinomialModel<U, I, F>
extends UserModel<U> {
    private final PreferenceData<U, I> recommenderData;
    private final FeatureData<I, F, ?> featureData;
    private final Object2DoubleMap<F> globalFeatureProbs;
    private final double alpha;

    public BinomialModel(boolean caching, Stream<U> targetUsers, PreferenceData<U, I> recommenderData, FeatureData<I, F, ?> featureData, double alpha) {
        super(caching, targetUsers);
        this.recommenderData = recommenderData;
        this.featureData = featureData;
        this.globalFeatureProbs = this.getGlobalFeatureProbs();
        this.alpha = alpha;
    }

    public Set<F> getFeatures() {
        return this.globalFeatureProbs.keySet();
    }

    public double p(F f) {
        return this.globalFeatureProbs.getDouble(f);
    }

    public UserBinomialModel get(U u) {
        return new UserBinomialModel(u);
    }

    public UserBinomialModel getModel(U u) {
        return (UserBinomialModel)super.getModel(u);
    }

    private Object2DoubleMap<F> getGlobalFeatureProbs() {
        Object2DoubleOpenHashMap probs = new Object2DoubleOpenHashMap();
        probs.defaultReturnValue(0.0);
        int n = this.recommenderData.numPreferences();
        ((Stream)this.featureData.getAllFeatures().sequential()).forEach(arg_0 -> this.lambda$getGlobalFeatureProbs$16((Object2DoubleMap)probs, n, arg_0));
        return probs;
    }

    private /* synthetic */ void lambda$getGlobalFeatureProbs$16(Object2DoubleMap probs, int n, Object f) {
        int numPrefs = this.featureData.getFeatureItems(f).map(Tuple2::v1).mapToInt(arg_0 -> this.recommenderData.numUsers(arg_0)).sum();
        probs.put(f, (double)numPrefs / (double)n);
    }

    public class UserBinomialModel
    implements UserModel.Model<U> {
        private final U user;
        private final Object2DoubleMap<F> featureProbs;

        private UserBinomialModel(U user) {
            this.user = user;
            this.featureProbs = this.getUserFeatureProbs();
        }

        public Set<F> getFeatures() {
            return this.featureProbs.keySet();
        }

        public double p(F f) {
            return this.featureProbs.getDouble(f);
        }

        public double longing(F f, int N) {
            return Math.pow(1.0 - this.p(f), N);
        }

        public double patience(int k, F f, int N) {
            double pf = this.p(f);
            BinomialDistribution dist = new BinomialDistribution(null, N, pf);
            double p0 = Math.pow(1.0 - pf, N);
            return 1.0 - (dist.cumulativeProbability(k - 1) - p0) / (1.0 - p0);
        }

        private Object2DoubleMap<F> getUserFeatureProbs() {
            if (BinomialModel.this.alpha == 0.0) {
                return BinomialModel.this.globalFeatureProbs;
            }
            Object2DoubleOpenHashMap probs = new Object2DoubleOpenHashMap();
            probs.defaultReturnValue(0.0);
            int n = BinomialModel.this.recommenderData.numItems(this.user);
            BinomialModel.this.recommenderData.getUserPreferences(this.user).forEach(pref -> BinomialModel.this.featureData.getItemFeatures(pref.v1).forEach(feature -> probs.addTo(feature.v1, 1.0)));
            if (probs.isEmpty()) {
                return BinomialModel.this.globalFeatureProbs;
            }
            probs.replaceAll((f, c) -> c / (double)n);
            if (BinomialModel.this.alpha < 1.0) {
                BinomialModel.this.globalFeatureProbs.object2DoubleEntrySet().forEach(e -> {
                    Object f = e.getKey();
                    double p = e.getDoubleValue();
                    probs.put(f, BinomialModel.this.alpha * probs.getDouble(f) + (1.0 - BinomialModel.this.alpha) * p);
                });
            }
            return probs;
        }
    }
}

