/*
 * Decompiled with CFR 0.152.
 */
package es.uam.eps.ir.ranksys.diversity.binom.metrics;

import es.uam.eps.ir.ranksys.core.feature.FeatureData;
import es.uam.eps.ir.ranksys.diversity.binom.BinomialModel;
import es.uam.eps.ir.ranksys.diversity.binom.metrics.BinomialMetric;
import es.uam.eps.ir.ranksys.metrics.rel.RelevanceModel;
import it.unimi.dsi.fastutil.objects.Object2IntMap;

public class BinomialCoverage<U, I, F>
extends BinomialMetric<U, I, F> {
    public BinomialCoverage(BinomialModel<U, I, F> binomialModel, FeatureData<I, F, ?> featureData, int cutoff, RelevanceModel<U, I> relModel) {
        super(binomialModel, featureData, cutoff, relModel);
    }

    @Override
    protected double getResultFromCount(BinomialModel.UserBinomialModel ubm, Object2IntMap<F> count, int nrel, int nret) {
        return BinomialCoverage.coverage(ubm, count, nret);
    }

    protected static <U, I, F> double coverage(BinomialModel.UserBinomialModel ubm, Object2IntMap<F> count, int nret) {
        double coverage = ubm.getFeatures().stream().filter(f -> !count.containsKey(f)).mapToDouble(f -> ubm.longing(f, nret)).reduce(1.0, (p, q) -> p * q);
        coverage = Math.pow(coverage, 1.0 / (double)ubm.getFeatures().size());
        return coverage;
    }
}

