/*
 * Decompiled with CFR 0.152.
 */
package es.uam.eps.ir.ranksys.diversity.binom.metrics;

import es.uam.eps.ir.ranksys.core.Recommendation;
import es.uam.eps.ir.ranksys.core.feature.FeatureData;
import es.uam.eps.ir.ranksys.core.model.UserModel;
import es.uam.eps.ir.ranksys.diversity.binom.BinomialModel;
import es.uam.eps.ir.ranksys.metrics.AbstractRecommendationMetric;
import es.uam.eps.ir.ranksys.metrics.rel.RelevanceModel;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import org.ranksys.core.util.tuples.Tuple2od;

public abstract class BinomialMetric<U, I, F>
extends AbstractRecommendationMetric<U, I> {
    private final BinomialModel<U, I, F> binomialModel;
    private final FeatureData<I, F, ?> featureData;
    private final int cutoff;
    protected final RelevanceModel<U, I> relModel;

    public BinomialMetric(BinomialModel<U, I, F> binomialModel, FeatureData<I, F, ?> featureData, int cutoff, RelevanceModel<U, I> relModel) {
        this.binomialModel = binomialModel;
        this.featureData = featureData;
        this.cutoff = cutoff;
        this.relModel = relModel;
    }

    public double evaluate(Recommendation<U, I> recommendation) {
        RelevanceModel.UserRelevanceModel userRelModel = this.relModel.getModel(recommendation.getUser());
        UserModel.Model prob = this.binomialModel.getModel(recommendation.getUser());
        Object2IntOpenHashMap count = new Object2IntOpenHashMap();
        count.defaultReturnValue(0);
        int rank = 0;
        int nrel = 0;
        for (Tuple2od iv : recommendation.getItems()) {
            if (userRelModel.isRelevant(iv.v1)) {
                this.featureData.getItemFeatures(iv.v1).forEach(fv -> count.addTo(fv.v1, 1));
                ++nrel;
            }
            if (++rank < this.cutoff) continue;
            break;
        }
        return this.getResultFromCount((BinomialModel.UserBinomialModel)prob, (Object2IntMap<F>)count, nrel, rank);
    }

    protected abstract double getResultFromCount(BinomialModel.UserBinomialModel var1, Object2IntMap<F> var2, int var3, int var4);
}

