/*
 * Decompiled with CFR 0.152.
 */
package es.uam.eps.ir.ranksys.diversity.binom.metrics;

import es.uam.eps.ir.ranksys.core.feature.FeatureData;
import es.uam.eps.ir.ranksys.diversity.binom.BinomialModel;
import es.uam.eps.ir.ranksys.diversity.binom.metrics.BinomialMetric;
import es.uam.eps.ir.ranksys.metrics.rel.RelevanceModel;
import it.unimi.dsi.fastutil.objects.Object2IntMap;

public class BinomialNonRedundancy<U, I, F>
extends BinomialMetric<U, I, F> {
    public BinomialNonRedundancy(BinomialModel<U, I, F> binomialModel, FeatureData<I, F, ?> featureData, int cutoff, RelevanceModel<U, I> relModel) {
        super(binomialModel, featureData, cutoff, relModel);
    }

    @Override
    protected double getResultFromCount(BinomialModel.UserBinomialModel prob, Object2IntMap<F> count, int nrel, int nret) {
        return BinomialNonRedundancy.nonRedundancy(prob, count, nrel);
    }

    protected static <U, I, F> double nonRedundancy(BinomialModel.UserBinomialModel ubm, Object2IntMap<F> count, int nrel) {
        if (nrel == 0 || count.isEmpty()) {
            return 0.0;
        }
        double nonRedundancy = ubm.getFeatures().stream().filter(f -> count.containsKey(f)).mapToDouble(f -> ubm.patience(count.getInt(f), f, nrel)).reduce(1.0, (p, q) -> p * q);
        nonRedundancy = Math.pow(nonRedundancy, 1.0 / (double)count.size());
        return nonRedundancy;
    }
}

