/*
 * Decompiled with CFR 0.152.
 */
package es.uam.eps.ir.ranksys.diversity.binom.reranking;

import es.uam.eps.ir.ranksys.core.Recommendation;
import es.uam.eps.ir.ranksys.core.feature.FeatureData;
import es.uam.eps.ir.ranksys.diversity.binom.BinomialModel;
import es.uam.eps.ir.ranksys.novdiv.reranking.LambdaReranker;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;
import org.jooq.lambda.tuple.Tuple2;
import org.ranksys.core.util.tuples.Tuple2od;

public class BinomialCoverageReranker<U, I, F>
extends LambdaReranker<U, I> {
    private final FeatureData<I, F, ?> featureData;
    private final BinomialModel<U, I, F> binomialModel;

    public BinomialCoverageReranker(FeatureData<I, F, ?> featureData, BinomialModel<U, I, F> binomialModel, double lambda, int cutoff) {
        super(lambda, cutoff, true);
        this.featureData = featureData;
        this.binomialModel = binomialModel;
    }

    protected BinomialCoverageUserReranker getUserReranker(Recommendation<U, I> recommendation, int maxLength) {
        return new BinomialCoverageUserReranker(recommendation, maxLength);
    }

    public class BinomialCoverageUserReranker
    extends LambdaReranker.LambdaUserReranker {
        private final BinomialModel.UserBinomialModel ubm;
        private final Set<F> uncoveredFeatures;
        private double coverage;

        public BinomialCoverageUserReranker(Recommendation<U, I> recommendation, int maxLength) {
            super((LambdaReranker)BinomialCoverageReranker.this, recommendation, maxLength);
            this.ubm = BinomialCoverageReranker.this.binomialModel.getModel(recommendation.getUser());
            this.uncoveredFeatures = new HashSet(this.ubm.getFeatures());
            this.coverage = this.uncoveredFeatures.stream().mapToDouble(f -> this.ubm.longing(f, BinomialCoverageReranker.this.cutoff)).reduce((x, y) -> x * y).orElse(1.0);
            this.coverage = Math.pow(this.coverage, 1.0 / (double)this.ubm.getFeatures().size());
        }

        protected double nov(Tuple2od<I> itemValue) {
            double iCoverage = BinomialCoverageReranker.this.featureData.getItemFeatures(itemValue.v1).map(Tuple2::v1).filter(this.uncoveredFeatures::contains).mapToDouble(f -> this.ubm.longing(f, BinomialCoverageReranker.this.cutoff)).reduce((x, y) -> x * y).orElse(1.0);
            iCoverage = Math.pow(iCoverage, 1.0 / (double)this.ubm.getFeatures().size());
            iCoverage = this.coverage / iCoverage;
            return iCoverage;
        }

        protected void update(Tuple2od<I> bestItemValue) {
            double iCoverage = ((Stream)BinomialCoverageReranker.this.featureData.getItemFeatures(bestItemValue.v1).sequential()).map(Tuple2::v1).filter(this.uncoveredFeatures::remove).mapToDouble(f -> this.ubm.longing(f, BinomialCoverageReranker.this.cutoff)).reduce((x, y) -> x * y).orElse(1.0);
            iCoverage = Math.pow(iCoverage, 1.0 / (double)this.ubm.getFeatures().size());
            this.coverage /= iCoverage;
        }
    }
}

