/*
 * Decompiled with CFR 0.152.
 */
package es.uam.eps.ir.ranksys.diversity.binom.reranking;

import es.uam.eps.ir.ranksys.core.Recommendation;
import es.uam.eps.ir.ranksys.core.feature.FeatureData;
import es.uam.eps.ir.ranksys.diversity.binom.BinomialModel;
import es.uam.eps.ir.ranksys.diversity.binom.reranking.BinomialCoverageReranker;
import es.uam.eps.ir.ranksys.diversity.binom.reranking.BinomialNonRedundancyReranker;
import es.uam.eps.ir.ranksys.novdiv.reranking.LambdaReranker;
import org.ranksys.core.util.tuples.Tuple2od;

public class BinomialDiversityReranker<U, I, F>
extends LambdaReranker<U, I> {
    private final BinomialCoverageReranker<U, I, F> coverageReranker;
    private final BinomialNonRedundancyReranker<U, I, F> nonRedundancyReranker;

    public BinomialDiversityReranker(FeatureData<I, F, ?> featureData, BinomialModel<U, I, F> binomialModel, double lambda, int cutoff) {
        super(lambda, cutoff, true);
        this.coverageReranker = new BinomialCoverageReranker<U, I, F>(featureData, binomialModel, lambda, cutoff);
        this.nonRedundancyReranker = new BinomialNonRedundancyReranker<U, I, F>(featureData, binomialModel, lambda, cutoff);
    }

    protected LambdaReranker.LambdaUserReranker getUserReranker(Recommendation<U, I> recommendation, int maxLength) {
        return new BinomialDiversityUserReranker(recommendation, maxLength);
    }

    protected class BinomialDiversityUserReranker
    extends LambdaReranker.LambdaUserReranker {
        private final BinomialCoverageReranker.BinomialCoverageUserReranker coverageUserReranker;
        private final BinomialNonRedundancyReranker.BinomialNonRedundancyUserReranker nonRedundancyUserReranker;

        public BinomialDiversityUserReranker(Recommendation<U, I> recommendation, int maxLength) {
            super((LambdaReranker)BinomialDiversityReranker.this, recommendation, maxLength);
            this.coverageUserReranker = BinomialDiversityReranker.this.coverageReranker.getUserReranker(recommendation, maxLength);
            this.nonRedundancyUserReranker = BinomialDiversityReranker.this.nonRedundancyReranker.getUserReranker(recommendation, maxLength);
        }

        protected double nov(Tuple2od<I> itemValue) {
            return this.coverageUserReranker.nov(itemValue) * this.nonRedundancyUserReranker.nov(itemValue);
        }

        protected void update(Tuple2od<I> bestItemValue) {
            this.coverageUserReranker.update(bestItemValue);
            this.nonRedundancyUserReranker.update(bestItemValue);
        }
    }
}

