/*
 * Decompiled with CFR 0.152.
 */
package es.uam.eps.ir.ranksys.diversity.binom.reranking;

import es.uam.eps.ir.ranksys.core.Recommendation;
import es.uam.eps.ir.ranksys.core.feature.FeatureData;
import es.uam.eps.ir.ranksys.diversity.binom.BinomialModel;
import es.uam.eps.ir.ranksys.novdiv.reranking.LambdaReranker;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.jooq.lambda.tuple.Tuple2;
import org.ranksys.core.util.tuples.Tuple2od;

public class BinomialNonRedundancyReranker<U, I, F>
extends LambdaReranker<U, I> {
    private final FeatureData<I, F, ?> featureData;
    private final BinomialModel<U, I, F> binomialModel;

    public BinomialNonRedundancyReranker(FeatureData<I, F, ?> featureData, BinomialModel<U, I, F> binomialModel, double lambda, int cutoff) {
        super(lambda, cutoff, true);
        this.featureData = featureData;
        this.binomialModel = binomialModel;
    }

    protected BinomialNonRedundancyUserReranker getUserReranker(Recommendation<U, I> recommendation, int maxLength) {
        return new BinomialNonRedundancyUserReranker(recommendation, maxLength);
    }

    protected class BinomialNonRedundancyUserReranker
    extends LambdaReranker.LambdaUserReranker {
        private final BinomialModel.UserBinomialModel ubm;
        private final Object2IntOpenHashMap<F> featureCount;
        private final Object2DoubleMap<F> patienceNow;
        private final Object2DoubleMap<F> patienceLater;

        public BinomialNonRedundancyUserReranker(Recommendation<U, I> recommendation, int maxLength) {
            super((LambdaReranker)BinomialNonRedundancyReranker.this, recommendation, maxLength);
            this.ubm = BinomialNonRedundancyReranker.this.binomialModel.getModel(recommendation.getUser());
            this.featureCount = new Object2IntOpenHashMap();
            this.featureCount.defaultReturnValue(0);
            this.patienceNow = new Object2DoubleOpenHashMap();
            this.patienceLater = new Object2DoubleOpenHashMap();
            this.ubm.getFeatures().forEach(f -> {
                this.patienceNow.put(f, this.ubm.patience(0, f, BinomialNonRedundancyReranker.this.cutoff));
                this.patienceLater.put(f, this.ubm.patience(1, f, BinomialNonRedundancyReranker.this.cutoff));
            });
        }

        protected double nov(Tuple2od<I> itemValue) {
            Set itemFeatures = BinomialNonRedundancyReranker.this.featureData.getItemFeatures(itemValue.v1).map(Tuple2::v1).collect(Collectors.toCollection(() -> new HashSet()));
            double iNonRed = this.featureCount.keySet().stream().mapToDouble(f -> {
                if (itemFeatures.contains(f)) {
                    return this.patienceLater.getDouble(f);
                }
                return this.patienceNow.getDouble(f);
            }).reduce((x, y) -> x * y).orElse(1.0);
            int m = this.featureCount.size() + (int)itemFeatures.stream().filter(f -> !this.featureCount.containsKey(f)).count();
            iNonRed = Math.pow(iNonRed, 1.0 / (double)m);
            return iNonRed;
        }

        protected void update(Tuple2od<I> bestItemValue) {
            BinomialNonRedundancyReranker.this.featureData.getItemFeatures(bestItemValue.v1).map(Tuple2::v1).forEach(f -> {
                int c = this.featureCount.addTo(f, 1) + 1;
                this.patienceNow.put(f, this.patienceLater.getDouble(f));
                this.patienceLater.put(f, this.ubm.patience(c + 1, f, BinomialNonRedundancyReranker.this.cutoff));
            });
        }
    }
}

