/*
 * Decompiled with CFR 0.152.
 */
package es.uam.eps.ir.ranksys.diversity.distance.metrics;

import es.uam.eps.ir.ranksys.core.Recommendation;
import es.uam.eps.ir.ranksys.metrics.AbstractRecommendationMetric;
import es.uam.eps.ir.ranksys.metrics.rank.RankingDiscountModel;
import es.uam.eps.ir.ranksys.metrics.rel.RelevanceModel;
import es.uam.eps.ir.ranksys.novdiv.distance.ItemDistanceModel;
import java.util.List;
import java.util.function.ToDoubleFunction;
import org.ranksys.core.util.tuples.Tuple2od;

public class EILD<U, I>
extends AbstractRecommendationMetric<U, I> {
    private final int cutoff;
    private final ItemDistanceModel<I> distModel;
    private final RelevanceModel<U, I> relModel;
    private final RankingDiscountModel disc1;
    private final RankingDiscountModel disc2;

    public EILD(int cutoff, ItemDistanceModel<I> distModel, RelevanceModel<U, I> relModel, RankingDiscountModel disc) {
        this(cutoff, distModel, relModel, disc, disc);
    }

    public EILD(int cutoff, ItemDistanceModel<I> distModel, RelevanceModel<U, I> relModel, RankingDiscountModel disc1, RankingDiscountModel disc2) {
        this.cutoff = cutoff;
        this.distModel = distModel;
        this.relModel = relModel;
        this.disc1 = disc1;
        this.disc2 = disc2;
    }

    public double evaluate(Recommendation<U, I> recommendation) {
        RelevanceModel.UserRelevanceModel userRelModel = this.relModel.getModel(recommendation.getUser());
        List items = recommendation.getItems();
        int N = Math.min(this.cutoff, items.size());
        double eild = 0.0;
        double norm = 0.0;
        for (int i = 0; i < N; ++i) {
            double ieild = 0.0;
            double inorm = 0.0;
            ToDoubleFunction iDist = this.distModel.dist(((Tuple2od)items.get((int)i)).v1);
            for (int j = 0; j < N; ++j) {
                double dist;
                if (i == j || Double.isNaN(dist = iDist.applyAsDouble(((Tuple2od)items.get((int)j)).v1))) continue;
                double w = this.disc2.disc(Math.max(0, j - i - 1)) * userRelModel.gain(((Tuple2od)items.get((int)j)).v1);
                ieild += w * dist;
                inorm += w;
            }
            if (inorm > 0.0) {
                eild += this.disc1.disc(i) * userRelModel.gain(((Tuple2od)items.get((int)i)).v1) * ieild / inorm;
            }
            norm += this.disc1.disc(i);
        }
        if (norm > 0.0) {
            eild /= norm;
        }
        return eild;
    }
}

