/*
 * Decompiled with CFR 0.152.
 */
package es.uam.eps.ir.ranksys.diversity.distance.reranking;

import es.uam.eps.ir.ranksys.core.Recommendation;
import es.uam.eps.ir.ranksys.novdiv.distance.ItemDistanceModel;
import es.uam.eps.ir.ranksys.novdiv.reranking.LambdaReranker;
import it.unimi.dsi.fastutil.objects.Object2DoubleOpenHashMap;
import java.util.function.ToDoubleFunction;
import java.util.stream.Stream;
import org.ranksys.core.util.tuples.Tuple2od;

public class MMR<U, I>
extends LambdaReranker<U, I> {
    private final ItemDistanceModel<I> dist;

    public MMR(double lambda, int cutoff, ItemDistanceModel<I> dist) {
        super(lambda, cutoff, true);
        this.dist = dist;
    }

    protected LambdaReranker.LambdaUserReranker getUserReranker(Recommendation<U, I> recommendation, int maxLength) {
        return new UserMMR(recommendation, maxLength);
    }

    public class UserMMR
    extends LambdaReranker.LambdaUserReranker {
        private final Object2DoubleOpenHashMap<I> avgDist;
        private int n;

        public UserMMR(Recommendation<U, I> recommendation, int maxLength) {
            super((LambdaReranker)MMR.this, recommendation, maxLength);
            this.n = 0;
            this.avgDist = new Object2DoubleOpenHashMap();
            this.avgDist.defaultReturnValue(0.0);
            ((Stream)recommendation.getItems().stream().sequential()).map(Tuple2od::v1).forEach(i -> this.avgDist.put(i, 0.0));
        }

        protected double nov(Tuple2od<I> itemValue) {
            return this.avgDist.getDouble(itemValue.v1);
        }

        protected void update(Tuple2od<I> bestItemValue) {
            Object bestItem = bestItemValue.v1;
            ToDoubleFunction bDist = MMR.this.dist.dist(bestItem);
            this.avgDist.remove(bestItem);
            ++this.n;
            this.avgDist.object2DoubleEntrySet().forEach(e -> {
                Object i = e.getKey();
                double d = e.getDoubleValue();
                double d2 = bDist.applyAsDouble(i);
                this.avgDist.addTo(i, (d2 - d) / (double)this.n);
            });
        }
    }
}

