/*
 * Decompiled with CFR 0.152.
 */
package es.uam.eps.ir.ranksys.diversity.intentaware;

import es.uam.eps.ir.ranksys.core.feature.FeatureData;
import es.uam.eps.ir.ranksys.core.preference.PreferenceData;
import es.uam.eps.ir.ranksys.diversity.intentaware.IntentModel;
import it.unimi.dsi.fastutil.objects.Object2DoubleOpenHashMap;
import java.util.Set;
import java.util.stream.Stream;
import org.jooq.lambda.tuple.Tuple2;

public class FeatureIntentModel<U, I, F>
extends IntentModel<U, I, F> {
    protected final PreferenceData<U, I> totalData;
    protected final FeatureData<I, F, ?> featureData;
    protected Object2DoubleOpenHashMap<F> featureNorms;

    public FeatureIntentModel(Stream<U> targetUsers, PreferenceData<U, I> totalData, FeatureData<I, F, ?> featureData) {
        super(targetUsers);
        this.totalData = totalData;
        this.featureData = featureData;
        this.init();
    }

    public FeatureIntentModel(PreferenceData<U, I> totalData, FeatureData<I, F, ?> featureData) {
        this.totalData = totalData;
        this.featureData = featureData;
        this.init();
    }

    private void init() {
        this.featureNorms = new Object2DoubleOpenHashMap();
        this.featureData.getAllFeatures().forEach(f -> {
            int count = this.featureData.getFeatureItems(f).map(Tuple2::v1).mapToInt(arg_0 -> this.totalData.numUsers(arg_0)).sum();
            this.featureNorms.put(f, (double)count);
        });
    }

    @Override
    protected IntentModel.UserIntentModel<U, I, F> get(U user) {
        return new FeatureUserIntentModel(user);
    }

    public class FeatureUserIntentModel
    implements IntentModel.UserIntentModel<U, I, F> {
        protected final Object2DoubleOpenHashMap<F> pfu;

        public FeatureUserIntentModel(U user) {
            Object2DoubleOpenHashMap tmpCounts = new Object2DoubleOpenHashMap();
            tmpCounts.defaultReturnValue(0.0);
            int[] norm = new int[]{0};
            FeatureIntentModel.this.totalData.getUserPreferences(user).forEach(iv -> FeatureIntentModel.this.featureData.getItemFeatures(iv.v1).forEach(fv -> {
                tmpCounts.addTo(fv.v1, 1.0);
                norm[0] = norm[0] + 1;
            }));
            if (norm[0] == 0) {
                norm[0] = FeatureIntentModel.this.featureData.numFeatures();
                ((Stream)FeatureIntentModel.this.featureData.getAllFeatures().sequential()).forEach(f -> tmpCounts.put(f, 1.0));
            }
            this.pfu = new Object2DoubleOpenHashMap();
            tmpCounts.object2DoubleEntrySet().forEach(e -> {
                Object f = e.getKey();
                this.pfu.put(f, e.getDoubleValue() / (double)norm[0]);
            });
        }

        @Override
        public Set<F> getIntents() {
            return this.pfu.keySet();
        }

        @Override
        public Stream<F> getItemIntents(I i) {
            return FeatureIntentModel.this.featureData.getItemFeatures(i).map(Tuple2::v1).filter(arg_0 -> this.pfu.containsKey(arg_0));
        }

        @Override
        public double pf_u(F f) {
            return this.pfu.getDouble(f);
        }
    }
}

