/*
 * Decompiled with CFR 0.152.
 */
package es.uam.eps.ir.ranksys.diversity.intentaware.metrics;

import es.uam.eps.ir.ranksys.core.Recommendation;
import es.uam.eps.ir.ranksys.core.feature.FeatureData;
import es.uam.eps.ir.ranksys.core.model.UserModel;
import es.uam.eps.ir.ranksys.diversity.intentaware.metrics.AlphaNDCG;
import es.uam.eps.ir.ranksys.metrics.AbstractRecommendationMetric;
import es.uam.eps.ir.ranksys.metrics.rank.LogarithmicDiscountModel;
import es.uam.eps.ir.ranksys.metrics.rank.RankingDiscountModel;
import es.uam.eps.ir.ranksys.metrics.rel.BinaryRelevanceModel;
import es.uam.eps.ir.ranksys.metrics.rel.IdealRelevanceModel;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.HashSet;
import java.util.stream.Stream;
import org.jooq.lambda.tuple.Tuple2;
import org.ranksys.core.util.tuples.Tuple2od;

public class AlphaNDCG<U, I, F>
extends AbstractRecommendationMetric<U, I> {
    private final int cutoff;
    private final double alpha;
    private final IdealRelevanceModel<U, I> relModel;
    private final FeatureData<I, F, ?> featureData;
    private final AlphaNDCGIdeal idcg;
    private final RankingDiscountModel disc = new LogarithmicDiscountModel();

    public AlphaNDCG(int cutoff, double alpha, FeatureData<I, F, ?> featureData, BinaryRelevanceModel<U, I> relModel) {
        this.cutoff = cutoff;
        this.alpha = alpha;
        this.relModel = relModel;
        this.featureData = featureData;
        this.idcg = new AlphaNDCGIdeal();
    }

    public double evaluate(Recommendation<U, I> recommendation) {
        IdealRelevanceModel.UserIdealRelevanceModel urm = this.relModel.getModel(recommendation.getUser());
        double ndcg = 0.0;
        int rank = 0;
        Object2IntOpenHashMap redundancy = new Object2IntOpenHashMap();
        redundancy.defaultReturnValue(0);
        for (Tuple2od pair : recommendation.getItems()) {
            if (urm.isRelevant(pair.v1)) {
                double gain = ((Stream)this.featureData.getItemFeatures(pair.v1).sequential()).map(Tuple2::v1).mapToDouble(f -> {
                    int r = redundancy.addTo(f, 1);
                    return Math.pow(1.0 - this.alpha, r);
                }).sum();
                ndcg += gain * this.disc.disc(rank);
            }
            if (++rank < this.cutoff) continue;
            break;
        }
        if (ndcg > 0.0) {
            ndcg /= this.idcg.getModel((Object)recommendation.getUser()).ideal;
        }
        return ndcg;
    }

    private double idcg(IdealRelevanceModel.UserIdealRelevanceModel<U, I> urm) {
        double ideal = 0.0;
        Object2IntOpenHashMap redundancy = new Object2IntOpenHashMap();
        redundancy.defaultReturnValue(0);
        HashSet candidates = new HashSet(urm.getRelevantItems());
        for (int rank = 0; rank <= this.cutoff && !candidates.isEmpty(); ++rank) {
            Object bi = null;
            double bg = Double.NEGATIVE_INFINITY;
            for (Object i : candidates) {
                double gain = this.featureData.getItemFeatures(i).map(Tuple2::v1).mapToDouble(f -> Math.pow(1.0 - this.alpha, redundancy.getInt(f))).sum();
                if (!(gain > bg)) continue;
                bg = gain;
                bi = i;
            }
            candidates.remove(bi);
            ((Stream)this.featureData.getItemFeatures(bi).sequential()).map(Tuple2::v1).forEach(f -> redundancy.addTo(f, 1));
            ideal += bg * this.disc.disc(rank);
        }
        return ideal;
    }

    private class AlphaNDCGIdeal
    extends UserModel<U> {
        public AlphaNDCGIdeal() {
            super((UserModel)AlphaNDCG.this.relModel);
        }

        protected es.uam.eps.ir.ranksys.diversity.intentaware.metrics.AlphaNDCG$AlphaNDCGIdeal.UserAlphaNDCGIdeal get(U u) {
            return new UserAlphaNDCGIdeal(AlphaNDCG.this.idcg(AlphaNDCG.this.relModel.getModel(u)));
        }

        public es.uam.eps.ir.ranksys.diversity.intentaware.metrics.AlphaNDCG$AlphaNDCGIdeal.UserAlphaNDCGIdeal getModel(U u) {
            return (UserAlphaNDCGIdeal)super.getModel(u);
        }

        public class UserAlphaNDCGIdeal
        implements UserModel.Model<U> {
            public final double ideal;

            public UserAlphaNDCGIdeal(double ideal) {
                this.ideal = ideal;
            }
        }
    }
}

