/*
 * Decompiled with CFR 0.152.
 */
package es.uam.eps.ir.ranksys.diversity.intentaware.metrics;

import es.uam.eps.ir.ranksys.core.Recommendation;
import es.uam.eps.ir.ranksys.core.model.UserModel;
import es.uam.eps.ir.ranksys.core.preference.PreferenceData;
import es.uam.eps.ir.ranksys.diversity.intentaware.IntentModel;
import es.uam.eps.ir.ranksys.metrics.AbstractRecommendationMetric;
import es.uam.eps.ir.ranksys.metrics.rel.RelevanceModel;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleOpenHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.DoubleAdder;
import org.ranksys.core.util.tuples.Tuple2od;

public class ERRIA<U, I, F>
extends AbstractRecommendationMetric<U, I> {
    private final int cutoff;
    private final ERRRelevanceModel<U, I> relModel;
    private final IntentModel<U, I, F> intentModel;

    public ERRIA(int cutoff, IntentModel<U, I, F> intentModel, ERRRelevanceModel<U, I> relevanceModel) {
        this.cutoff = cutoff;
        this.relModel = relevanceModel;
        this.intentModel = intentModel;
    }

    public double evaluate(Recommendation<U, I> recommendation) {
        RelevanceModel.UserRelevanceModel userRelModel = this.relModel.getModel(recommendation.getUser());
        UserModel.Model uim = this.intentModel.getModel(recommendation.getUser());
        DoubleAdder erria = new DoubleAdder();
        Object2DoubleOpenHashMap pNoPrevRel = new Object2DoubleOpenHashMap();
        pNoPrevRel.defaultReturnValue(0.0);
        uim.getIntents().forEach(arg_0 -> ERRIA.lambda$evaluate$44((Object2DoubleMap)pNoPrevRel, arg_0));
        AtomicInteger rank = new AtomicInteger();
        recommendation.getItems().stream().limit(this.cutoff).forEach(arg_0 -> ERRIA.lambda$evaluate$46(userRelModel, (IntentModel.UserIntentModel)uim, (Object2DoubleMap)pNoPrevRel, erria, rank, arg_0));
        return erria.doubleValue();
    }

    private static /* synthetic */ void lambda$evaluate$46(RelevanceModel.UserRelevanceModel userRelModel, IntentModel.UserIntentModel uim, Object2DoubleMap pNoPrevRel, DoubleAdder erria, AtomicInteger rank, Tuple2od iv) {
        if (userRelModel.isRelevant(iv.v1)) {
            double gain = userRelModel.gain(iv.v1);
            uim.getItemIntents(iv.v1).forEach(f -> {
                double red = pNoPrevRel.getDouble(f);
                erria.add(uim.pf_u(f) * gain * red / (1.0 + (double)rank.intValue()));
                pNoPrevRel.put(f, red * (1.0 - gain));
            });
        }
        rank.incrementAndGet();
    }

    private static /* synthetic */ void lambda$evaluate$44(Object2DoubleMap pNoPrevRel, Object f) {
        pNoPrevRel.put(f, 1.0);
    }

    public static class ERRRelevanceModel<U, I>
    extends RelevanceModel<U, I> {
        private final PreferenceData<U, I> testData;
        private final double threshold;
        private final double maxPreference;

        public ERRRelevanceModel(boolean caching, PreferenceData<U, I> testData, double threshold) {
            super(caching, testData.getUsersWithPreferences());
            this.testData = testData;
            this.threshold = threshold;
            this.maxPreference = testData.getUsersWithPreferences().mapToDouble(u -> testData.getUserPreferences(u).mapToDouble(Tuple2od::v2).max().orElse(Double.NEGATIVE_INFINITY)).max().orElse(Double.NEGATIVE_INFINITY);
        }

        protected RelevanceModel.UserRelevanceModel<U, I> get(U user) {
            return new UserERRRelevanceModel(user);
        }

        public class UserERRRelevanceModel
        implements RelevanceModel.UserRelevanceModel<U, I> {
            private final Object2DoubleMap<I> gainMap = new Object2DoubleOpenHashMap();

            public UserERRRelevanceModel(U user) {
                this.gainMap.defaultReturnValue(0.0);
                ERRRelevanceModel.this.testData.getUserPreferences(user).filter(iv -> iv.v2 >= ERRRelevanceModel.this.threshold).forEach(iv -> this.gainMap.put(iv.v1, (Math.pow(2.0, iv.v2) - 1.0) / Math.pow(2.0, ERRRelevanceModel.this.maxPreference)));
            }

            public boolean isRelevant(I item) {
                return this.gainMap.containsKey(item);
            }

            public double gain(I item) {
                return this.gainMap.getDouble(item);
            }
        }
    }
}

