/*
 * Decompiled with CFR 0.152.
 */
package es.uam.eps.ir.ranksys.diversity.intentaware.reranking;

import es.uam.eps.ir.ranksys.core.Recommendation;
import es.uam.eps.ir.ranksys.diversity.intentaware.AspectModel;
import es.uam.eps.ir.ranksys.novdiv.reranking.LambdaReranker;
import it.unimi.dsi.fastutil.objects.Object2DoubleOpenHashMap;
import java.util.stream.Stream;
import org.ranksys.core.util.tuples.Tuple2od;

public class AlphaXQuAD<U, I, F>
extends LambdaReranker<U, I> {
    protected final AspectModel<U, I, F> aspectModel;
    private final double alpha;

    public AlphaXQuAD(AspectModel<U, I, F> aspectModel, double alpha, double lambda, int cutoff, boolean norm) {
        super(lambda, cutoff, norm);
        this.aspectModel = aspectModel;
        this.alpha = alpha;
    }

    protected LambdaReranker.LambdaUserReranker getUserReranker(Recommendation<U, I> recommendation, int maxLength) {
        return new UserAlphaXQuAD(recommendation, maxLength);
    }

    protected class UserAlphaXQuAD
    extends LambdaReranker.LambdaUserReranker {
        private final AspectModel.UserAspectModel uam;
        private final Object2DoubleOpenHashMap<F> redundancy;

        public UserAlphaXQuAD(Recommendation<U, I> recommendation, int maxLength) {
            super((LambdaReranker)AlphaXQuAD.this, recommendation, maxLength);
            this.uam = AlphaXQuAD.this.aspectModel.getModel(recommendation.getUser());
            this.uam.initializeWithItems(recommendation.getItems());
            this.redundancy = new Object2DoubleOpenHashMap();
            this.redundancy.defaultReturnValue(1.0);
        }

        protected double nov(Tuple2od<I> iv) {
            return this.uam.getItemIntents(iv.v1).mapToDouble(f -> this.uam.pf_u(f) * this.uam.pi_f(iv, f) * this.redundancy.getDouble(f)).sum();
        }

        protected void update(Tuple2od<I> biv) {
            ((Stream)this.uam.getItemIntents(biv.v1).sequential()).forEach(f -> this.redundancy.put(f, this.redundancy.getDouble(f) * (1.0 - AlphaXQuAD.this.alpha * this.uam.pi_f(biv, f))));
        }
    }
}

