/*
 * Decompiled with CFR 0.152.
 */
package es.uam.eps.ir.ranksys.diversity.other.metrics;

import es.uam.eps.ir.ranksys.core.Recommendation;
import es.uam.eps.ir.ranksys.core.feature.FeatureData;
import es.uam.eps.ir.ranksys.metrics.AbstractRecommendationMetric;
import es.uam.eps.ir.ranksys.metrics.rel.RelevanceModel;
import java.util.HashSet;
import java.util.stream.Collectors;
import org.jooq.lambda.tuple.Tuple2;
import org.ranksys.core.util.tuples.Tuple2od;

public class SRecall<U, I, F>
extends AbstractRecommendationMetric<U, I> {
    private final FeatureData<I, F, ?> featureData;
    private final int cutoff;
    protected final RelevanceModel<U, I> relModel;

    public SRecall(FeatureData<I, F, ?> featureData, int cutoff, RelevanceModel<U, I> relModel) {
        this.featureData = featureData;
        this.cutoff = cutoff;
        this.relModel = relModel;
    }

    public double evaluate(Recommendation<U, I> recommendation) {
        RelevanceModel.UserRelevanceModel userRelModel = this.relModel.getModel(recommendation.getUser());
        HashSet subtopics = new HashSet();
        int rank = 0;
        for (Tuple2od iv : recommendation.getItems()) {
            if (userRelModel.isRelevant(iv.v1)) {
                subtopics.addAll(this.featureData.getItemFeatures(iv.v1).map(Tuple2::v1).collect(Collectors.toList()));
            }
            if (++rank < this.cutoff) continue;
            break;
        }
        return (double)subtopics.size() / (double)this.featureData.numFeatures();
    }
}

