/*
 * Decompiled with CFR 0.152.
 */
package es.uam.eps.ir.ranksys.diversity.sales.metrics;

import es.uam.eps.ir.ranksys.core.Recommendation;
import es.uam.eps.ir.ranksys.metrics.AbstractSystemMetric;
import es.uam.eps.ir.ranksys.metrics.SystemMetric;
import es.uam.eps.ir.ranksys.metrics.rank.RankingDiscountModel;
import es.uam.eps.ir.ranksys.metrics.rel.RelevanceModel;
import it.unimi.dsi.fastutil.objects.Object2DoubleOpenHashMap;
import java.util.List;
import java.util.stream.IntStream;
import org.ranksys.core.util.tuples.Tuple2od;

public abstract class AbstractSalesDiversityMetric<U, I>
extends AbstractSystemMetric<U, I> {
    protected final int cutoff;
    private final RankingDiscountModel disc;
    private final RelevanceModel<U, I> rel;
    protected final Object2DoubleOpenHashMap<I> itemCount;
    protected final Object2DoubleOpenHashMap<I> itemWeight;
    protected double freeNorm;
    protected int numUsers;

    public AbstractSalesDiversityMetric(int cutoff, RankingDiscountModel disc, RelevanceModel<U, I> rel) {
        this.cutoff = cutoff;
        this.disc = disc;
        this.rel = rel;
        this.itemCount = new Object2DoubleOpenHashMap();
        this.itemCount.defaultReturnValue(0.0);
        this.itemWeight = new Object2DoubleOpenHashMap();
        this.itemWeight.defaultReturnValue(0.0);
        this.freeNorm = 0.0;
        this.numUsers = 0;
    }

    public void add(Recommendation<U, I> recommendation) {
        RelevanceModel.UserRelevanceModel urm = this.rel.getModel(recommendation.getUser());
        List list = recommendation.getItems();
        int rank = Math.min(this.cutoff, list.size());
        double userNorm = IntStream.range(0, rank).mapToDouble(arg_0 -> ((RankingDiscountModel)this.disc).disc(arg_0)).sum();
        IntStream.range(0, rank).forEach(k -> {
            Object i = ((Tuple2od)list.get((int)k)).v1;
            double d = this.disc.disc(k);
            double w = d * urm.gain(i) / userNorm;
            this.itemCount.addTo(i, d);
            this.itemWeight.addTo(i, w);
        });
        this.freeNorm += userNorm;
        ++this.numUsers;
    }

    public void combine(SystemMetric<U, I> other) {
        AbstractSalesDiversityMetric otherM = (AbstractSalesDiversityMetric)other;
        otherM.itemCount.object2DoubleEntrySet().forEach(e -> this.itemCount.addTo(e.getKey(), e.getDoubleValue()));
        otherM.itemWeight.object2DoubleEntrySet().forEach(e -> this.itemWeight.addTo(e.getKey(), e.getDoubleValue()));
        this.freeNorm += otherM.freeNorm;
        this.numUsers += otherM.numUsers;
    }

    protected abstract double nov(I var1);

    public double evaluate() {
        return this.itemCount.keySet().stream().mapToDouble(i -> this.itemWeight.getDouble(i) * this.nov(i)).sum() / (double)this.numUsers;
    }

    public void reset() {
        this.itemCount.clear();
        this.itemWeight.clear();
        this.freeNorm = 0.0;
        this.numUsers = 0;
    }
}

