/*
 * Decompiled with CFR 0.152.
 */
package es.uam.eps.ir.ranksys.diversity.sales.metrics;

import es.uam.eps.ir.ranksys.diversity.sales.metrics.AbstractSalesDiversityMetric;
import es.uam.eps.ir.ranksys.metrics.rank.NoDiscountModel;
import es.uam.eps.ir.ranksys.metrics.rank.RankingDiscountModel;
import es.uam.eps.ir.ranksys.metrics.rel.NoRelevanceModel;
import java.util.Arrays;

public class GiniIndex<U, I>
extends AbstractSalesDiversityMetric<U, I> {
    private final int numItems;

    public GiniIndex(int cutoff, int numItems) {
        super(cutoff, (RankingDiscountModel)new NoDiscountModel(), new NoRelevanceModel());
        this.numItems = numItems;
    }

    @Override
    public double evaluate() {
        double gi = 0.0;
        double[] cs = this.itemCount.values().toDoubleArray();
        Arrays.sort(cs);
        for (int j = 0; j < cs.length; ++j) {
            gi += (double)(2 * (j + (this.numItems - cs.length) + 1) - this.numItems - 1) * (cs[j] / this.freeNorm);
        }
        gi /= (double)(this.numItems - 1);
        gi = 1.0 - gi;
        return gi;
    }

    @Override
    protected double nov(I i) {
        throw new UnsupportedOperationException("Using an alternative item novelty aggregation model");
    }
}

