/*
 * Decompiled with CFR 0.152.
 */
package org.ranksys.diversity.prop.metrics;

import es.uam.eps.ir.ranksys.core.Recommendation;
import es.uam.eps.ir.ranksys.core.feature.FeatureData;
import es.uam.eps.ir.ranksys.core.model.UserModel;
import es.uam.eps.ir.ranksys.diversity.binom.BinomialModel;
import es.uam.eps.ir.ranksys.metrics.AbstractRecommendationMetric;
import es.uam.eps.ir.ranksys.metrics.rel.NoRelevanceModel;
import es.uam.eps.ir.ranksys.metrics.rel.RelevanceModel;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import org.ranksys.core.util.tuples.Tuple2od;

public class CPR<U, I, F>
extends AbstractRecommendationMetric<U, I> {
    private final BinomialModel<U, I, F> binomialModel;
    private final FeatureData<I, F, ?> featureData;
    private final int cutoff;
    private final RelevanceModel<U, I> relModel;

    public CPR(BinomialModel<U, I, F> binomialModel, FeatureData<I, F, ?> featureData, int cutoff, RelevanceModel<U, I> relModel) {
        this.binomialModel = binomialModel;
        this.featureData = featureData;
        this.cutoff = cutoff;
        this.relModel = relModel;
    }

    public double evaluate(Recommendation<U, I> recommendation) {
        RelevanceModel.UserRelevanceModel userRelModel = this.relModel.getModel(recommendation.getUser());
        UserModel.Model prob = this.binomialModel.getModel(recommendation.getUser());
        Object2IntOpenHashMap count = new Object2IntOpenHashMap();
        count.defaultReturnValue(0);
        int rank = 0;
        int nr = 0;
        double cpr = 0.0;
        for (Tuple2od iv : recommendation.getItems()) {
            if (userRelModel.isRelevant(iv.v1)) {
                this.featureData.getItemFeatures(iv.v1).forEach(fv -> count.addTo(fv.v1, 1));
            } else {
                ++nr;
            }
            double[] disprop = new double[]{0.5 * (double)nr * (double)nr};
            double[] ideal = new double[]{0.0};
            ideal[0] = this.relModel instanceof NoRelevanceModel ? 0.0 : 0.5 * (double)(rank + 1) * (double)(rank + 1);
            int _rank = rank++;
            prob.getFeatures().forEach(arg_0 -> CPR.lambda$evaluate$43((BinomialModel.UserBinomialModel)prob, _rank, count, disprop, ideal, arg_0));
            cpr += 1.0 - disprop[0] / ideal[0];
            if (rank < this.cutoff) continue;
            break;
        }
        return cpr /= (double)rank;
    }

    private static /* synthetic */ void lambda$evaluate$43(BinomialModel.UserBinomialModel prob, int _rank, Object2IntOpenHashMap count, double[] disprop, double[] ideal, Object f) {
        int c;
        double v = prob.p(f) * (double)(_rank + 1);
        if (v >= (double)(c = count.getInt(f))) {
            disprop[0] = disprop[0] + (v - (double)c) * (v - (double)c);
        }
        ideal[0] = ideal[0] + v * v;
    }
}

