/*
 * Decompiled with CFR 0.152.
 */
package org.ranksys.diversity.prop.reranking;

import es.uam.eps.ir.ranksys.core.Recommendation;
import es.uam.eps.ir.ranksys.core.feature.FeatureData;
import es.uam.eps.ir.ranksys.diversity.binom.BinomialModel;
import es.uam.eps.ir.ranksys.novdiv.reranking.GreedyReranker;
import it.unimi.dsi.fastutil.objects.Object2DoubleOpenHashMap;
import java.util.stream.Stream;
import org.jooq.lambda.tuple.Tuple2;
import org.ranksys.core.util.tuples.Tuple2od;

public class PM<U, I, F>
extends GreedyReranker<U, I> {
    private final double lambda;
    private final FeatureData<I, F, ?> featureData;
    private final BinomialModel<U, I, F> binomialModel;

    public PM(FeatureData<I, F, ?> featureData, BinomialModel<U, I, F> binomialModel, double lambda, int cutoff) {
        super(cutoff);
        this.lambda = lambda;
        this.featureData = featureData;
        this.binomialModel = binomialModel;
    }

    protected GreedyReranker.GreedyUserReranker<U, I> getUserReranker(Recommendation<U, I> recommendation, int maxLength) {
        return new UserPM(recommendation, maxLength);
    }

    private class UserPM
    extends GreedyReranker.GreedyUserReranker<U, I> {
        private final BinomialModel.UserBinomialModel ubm;
        private final Object2DoubleOpenHashMap<F> featureCount;
        private final Object2DoubleOpenHashMap<Object> probNorm;
        private F lcf;

        public UserPM(Recommendation<U, I> recommendation, int maxLength) {
            super((GreedyReranker)PM.this, recommendation, maxLength);
            this.ubm = PM.this.binomialModel.getModel(recommendation.getUser());
            this.featureCount = new Object2DoubleOpenHashMap();
            this.featureCount.defaultReturnValue(0.0);
            this.probNorm = new Object2DoubleOpenHashMap();
            recommendation.getItems().forEach(i -> ((Stream)PM.this.featureData.getItemFeatures(i.v1).sequential()).forEach(fv -> this.probNorm.addTo(fv.v1, i.v2)));
            this.lcf = this.getLcf();
        }

        private F getLcf() {
            return this.ubm.getFeatures().stream().max((f1, f2) -> Double.compare(this.quotient(f1), this.quotient(f2))).get();
        }

        private double quotient(F f) {
            return this.ubm.p(f) / (this.featureCount.getDouble(f) + 0.5);
        }

        protected double value(Tuple2od<I> iv) {
            return PM.this.featureData.getItemFeatures(iv.v1).map(Tuple2::v1).mapToDouble(f -> (f.equals(this.lcf) ? PM.this.lambda : 1.0 - PM.this.lambda) * this.quotient(f) * iv.v2 / this.probNorm.getDouble(f)).sum();
        }

        protected void update(Tuple2od<I> biv) {
            double norm = PM.this.featureData.getItemFeatures(biv.v1).map(Tuple2::v1).mapToDouble(f -> biv.v2 / this.probNorm.getDouble(f)).sum();
            ((Stream)PM.this.featureData.getItemFeatures(biv.v1).sequential()).map(Tuple2::v1).forEach(f -> {
                double v = biv.v2 / (this.probNorm.getDouble(f) * norm);
                this.featureCount.addTo(f, v);
            });
            this.lcf = this.getLcf();
        }
    }
}

