/*
 * Decompiled with CFR 0.152.
 */
package org.ranksys.fm;

import es.uam.eps.ir.ranksys.core.preference.IdPref;
import es.uam.eps.ir.ranksys.fast.index.FastItemIndex;
import es.uam.eps.ir.ranksys.fast.index.FastUserIndex;
import es.uam.eps.ir.ranksys.fast.preference.IdxPref;
import java.util.function.Function;
import java.util.stream.Stream;
import org.ranksys.core.util.tuples.Tuple2od;
import org.ranksys.javafm.FM;
import org.ranksys.javafm.FMInstance;

public class PreferenceFM<U, I>
implements FastUserIndex<U>,
FastItemIndex<I> {
    private static final double[] UI_VALUES = new double[]{1.0, 1.0};
    private final FastUserIndex<U> ui;
    private final FastItemIndex<I> ii;
    private final FM fm;
    private final Function<IdPref<I>, IdxPref> uPrefFun;

    public PreferenceFM(FastUserIndex<U> users, FastItemIndex<I> items, FM fm) {
        this(users, items, fm, p -> new IdxPref(items.item2iidx((Tuple2od)p)));
    }

    public PreferenceFM(FastUserIndex<U> users, FastItemIndex<I> items, FM fm, Function<IdPref<I>, IdxPref> uPrefFun) {
        this.ui = users;
        this.ii = items;
        this.fm = fm;
        this.uPrefFun = uPrefFun;
    }

    public FM getFM() {
        return this.fm;
    }

    public double predict(U u, IdPref<I> pref) {
        return this.predict(this.user2uidx(u), this.uPrefFun.apply(pref));
    }

    public double predict(int uidx, IdxPref pref) {
        return this.fm.predict(new FMInstance(pref.v2, new int[]{uidx, pref.v1 + this.numUsers()}, UI_VALUES));
    }

    public int user2uidx(U u) {
        return this.ui.user2uidx(u);
    }

    public U uidx2user(int i) {
        return (U)this.ui.uidx2user(i);
    }

    public boolean containsUser(U u) {
        return this.ui.containsUser(u);
    }

    public int numUsers() {
        return this.ui.numUsers();
    }

    public Stream<U> getAllUsers() {
        return this.ui.getAllUsers();
    }

    public int item2iidx(I i) {
        return this.ii.item2iidx(i);
    }

    public I iidx2item(int i) {
        return (I)this.ii.iidx2item(i);
    }

    public boolean containsItem(I i) {
        return this.ii.containsItem(i);
    }

    public int numItems() {
        return this.ii.numItems();
    }

    public Stream<I> getAllItems() {
        return this.ii.getAllItems();
    }
}

