/*
 * Decompiled with CFR 0.152.
 */
package org.ranksys.fm.data;

import es.uam.eps.ir.ranksys.fast.preference.FastPreferenceData;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Random;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.jooq.lambda.Seq;
import org.ranksys.javafm.FMInstance;
import org.ranksys.javafm.data.FMData;

public class BPRPreferenceFMData
implements FMData {
    private static final double[] UIJ_VALUES = new double[]{1.0, 2.0, 3.0};
    private final FastPreferenceData<?, ?> prefs;
    private final Random rnd;
    private final IntArrayList uidxs;
    private final IntArrayList iidxs;

    public BPRPreferenceFMData(FastPreferenceData<?, ?> prefs) {
        this(prefs, new Random());
    }

    public BPRPreferenceFMData(FastPreferenceData<?, ?> prefs, Random rnd) {
        this.prefs = prefs;
        this.rnd = rnd;
        this.uidxs = new IntArrayList();
        prefs.getUidxWithPreferences().forEach(arg_0 -> ((IntArrayList)this.uidxs).add(arg_0));
        this.iidxs = new IntArrayList();
        prefs.getIidxWithPreferences().forEach(arg_0 -> ((IntArrayList)this.iidxs).add(arg_0));
    }

    public int numFeatures() {
        return this.prefs.numUsers() + this.prefs.numItems();
    }

    public int numInstances() {
        return this.prefs.numPreferences();
    }

    public void shuffle() {
        IntArrays.shuffle((int[])this.uidxs.elements(), (int)0, (int)this.uidxs.size(), (Random)this.rnd);
    }

    private FMInstance getInstance(int uidx, int iidx, int jidx) {
        int nu = this.prefs.numUsers();
        return new FMInstance(1.0, new int[]{uidx, iidx + nu, jidx + nu}, UIJ_VALUES);
    }

    public Stream<? extends FMInstance> stream() {
        return this.uidxs.stream().flatMap(uidx -> {
            IntOpenHashSet uidxIidxs = new IntOpenHashSet();
            this.prefs.getUidxIidxs(uidx.intValue()).forEachRemaining(arg_0 -> ((IntSet)uidxIidxs).add(arg_0));
            return Seq.seq((IntStream)this.rnd.ints(this.iidxs.size(), 0, this.iidxs.size()).map(arg_0 -> ((IntArrayList)this.iidxs).getInt(arg_0))).filter(arg_0 -> BPRPreferenceFMData.lambda$null$7((IntSet)uidxIidxs, arg_0)).limit((long)uidxIidxs.size()).zip((Iterable)uidxIidxs).map(t -> this.getInstance((int)uidx, (Integer)t.v2, (Integer)t.v1)).shuffle();
        });
    }

    private static /* synthetic */ boolean lambda$null$7(IntSet uidxIidxs, Integer jidx) {
        return !uidxIidxs.contains((Object)jidx);
    }
}

