/*
 * Decompiled with CFR 0.152.
 */
package org.ranksys.fm.data;

import es.uam.eps.ir.ranksys.fast.preference.FastPreferenceData;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import java.util.stream.Stream;
import org.ranksys.javafm.FMInstance;
import org.ranksys.javafm.data.FMData;

public class OneClassPreferenceFMData
implements FMData {
    private static final double[] UI_VALUES = new double[]{1.0, 1.0};
    private final FastPreferenceData<?, ?> prefs;
    private final Random rnd;
    private final IntArrayList uidxs;
    private final IntArrayList iidxs;
    private final double negativeProp;

    public OneClassPreferenceFMData(FastPreferenceData<?, ?> prefs, double negativeProp) {
        this(prefs, negativeProp, new Random());
    }

    public OneClassPreferenceFMData(FastPreferenceData<?, ?> prefs, double negativeProp, Random rnd) {
        this.prefs = prefs;
        this.negativeProp = negativeProp;
        this.rnd = rnd;
        this.uidxs = new IntArrayList();
        prefs.getUidxWithPreferences().forEach(arg_0 -> ((IntArrayList)this.uidxs).add(arg_0));
        this.iidxs = new IntArrayList();
        prefs.getIidxWithPreferences().forEach(arg_0 -> ((IntArrayList)this.iidxs).add(arg_0));
    }

    public int numFeatures() {
        return this.prefs.numUsers() + this.prefs.numItems();
    }

    public int numInstances() {
        return this.prefs.numPreferences();
    }

    public void shuffle() {
        IntArrays.shuffle((int[])this.uidxs.elements(), (int)0, (int)this.uidxs.size(), (Random)this.rnd);
    }

    private FMInstance getInstance(int uidx, int iidx, double v) {
        return new FMInstance(v, new int[]{uidx, iidx + this.prefs.numUsers()}, UI_VALUES);
    }

    public Stream<? extends FMInstance> stream() {
        return this.uidxs.stream().flatMap(uidx -> {
            IntOpenHashSet uidxIidxs = new IntOpenHashSet();
            this.prefs.getUidxIidxs(uidx.intValue()).forEachRemaining(arg_0 -> ((IntSet)uidxIidxs).add(arg_0));
            ArrayList instances = new ArrayList();
            uidxIidxs.forEach(iidx -> instances.add(this.getInstance((int)uidx, (int)iidx, 1.0)));
            this.rnd.ints(this.iidxs.size(), 0, this.iidxs.size()).map(arg_0 -> ((IntArrayList)this.iidxs).getInt(arg_0)).filter(arg_0 -> OneClassPreferenceFMData.lambda$null$4((IntSet)uidxIidxs, arg_0)).distinct().limit((int)(this.negativeProp * (double)uidxIidxs.size())).forEach(jidx -> instances.add(this.getInstance((int)uidx, jidx, 0.0)));
            Collections.shuffle(instances);
            return instances.stream();
        });
    }

    private static /* synthetic */ boolean lambda$null$4(IntSet uidxIidxs, int jidx) {
        return !uidxIidxs.contains(jidx);
    }
}

