/*
 * Decompiled with CFR 0.152.
 */
package org.ranksys.fm.rec;

import es.uam.eps.ir.ranksys.fast.FastRecommendation;
import es.uam.eps.ir.ranksys.fast.preference.IdxPref;
import es.uam.eps.ir.ranksys.fast.utils.topn.IntDoubleTopN;
import es.uam.eps.ir.ranksys.rec.fast.AbstractFastRecommender;
import java.util.Comparator;
import java.util.List;
import java.util.function.IntPredicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.ranksys.core.util.tuples.Tuple2id;
import org.ranksys.core.util.tuples.Tuples;
import org.ranksys.fm.PreferenceFM;

public class FMRecommender<U, I>
extends AbstractFastRecommender<U, I> {
    private final PreferenceFM fm;

    public FMRecommender(PreferenceFM<U, I> fm) {
        super(fm, fm);
        this.fm = fm;
    }

    public FastRecommendation getRecommendation(int uidx, int maxLength, IntPredicate filter) {
        if (maxLength == 0) {
            maxLength = this.numItems();
        }
        IntDoubleTopN topN = new IntDoubleTopN(maxLength);
        this.getAllIidx().filter(filter).forEach(iidx -> topN.add(iidx, this.fm.predict(uidx, new IdxPref(iidx, Double.NaN))));
        topN.sort();
        List items = topN.reverseStream().collect(Collectors.toList());
        return new FastRecommendation(uidx, items);
    }

    public FastRecommendation getRecommendation(int uidx, IntStream candidates) {
        List items = candidates.mapToObj(iidx -> Tuples.tuple((int)iidx, (double)this.fm.predict(uidx, new IdxPref(iidx, Double.NaN)))).sorted(Comparator.comparingDouble(Tuple2id::v2).reversed()).collect(Collectors.toList());
        return new FastRecommendation(uidx, items);
    }
}

