/*
 * Decompiled with CFR 0.152.
 */
package es.uam.eps.ir.ranksys.mf;

import cern.colt.function.DoubleFunction;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import es.uam.eps.ir.ranksys.fast.index.FastItemIndex;
import es.uam.eps.ir.ranksys.fast.index.FastUserIndex;

public class Factorization<U, I>
implements FastItemIndex<I>,
FastUserIndex<U> {
    protected final DenseDoubleMatrix2D userMatrix;
    protected final DenseDoubleMatrix2D itemMatrix;
    protected final int K;
    protected final FastUserIndex<U> uIndex;
    protected final FastItemIndex<I> iIndex;

    public Factorization(FastUserIndex<U> uIndex, FastItemIndex<I> iIndex, int K, DoubleFunction initFunction) {
        this.userMatrix = new DenseDoubleMatrix2D(uIndex.numUsers(), K);
        this.userMatrix.assign(initFunction);
        this.itemMatrix = new DenseDoubleMatrix2D(iIndex.numItems(), K);
        this.itemMatrix.assign(initFunction);
        this.K = K;
        this.uIndex = uIndex;
        this.iIndex = iIndex;
    }

    public Factorization(FastUserIndex<U> uIndex, FastItemIndex<I> iIndex, DenseDoubleMatrix2D userMatrix, DenseDoubleMatrix2D itemMatrix, int K) {
        this.userMatrix = userMatrix;
        this.itemMatrix = itemMatrix;
        this.K = K;
        this.uIndex = uIndex;
        this.iIndex = iIndex;
    }

    public int numUsers() {
        return this.uIndex.numUsers();
    }

    public int user2uidx(U u) {
        return this.uIndex.user2uidx(u);
    }

    public U uidx2user(int uidx) {
        return (U)this.uIndex.uidx2user(uidx);
    }

    public int numItems() {
        return this.iIndex.numItems();
    }

    public int item2iidx(I i) {
        return this.iIndex.item2iidx(i);
    }

    public I iidx2item(int iidx) {
        return (I)this.iIndex.iidx2item(iidx);
    }

    public boolean containsUser(U u) {
        return this.uIndex.containsUser(u);
    }

    public boolean containsItem(I i) {
        return this.iIndex.containsItem(i);
    }

    public DoubleMatrix1D getUserVector(U u) {
        int uidx = this.user2uidx(u);
        if (uidx < 0) {
            return null;
        }
        return this.userMatrix.viewRow(uidx);
    }

    public DoubleMatrix1D getItemVector(I i) {
        int iidx = this.item2iidx(i);
        if (iidx < 0) {
            return null;
        }
        return this.itemMatrix.viewRow(iidx);
    }

    public DenseDoubleMatrix2D getUserMatrix() {
        return this.userMatrix;
    }

    public DenseDoubleMatrix2D getItemMatrix() {
        return this.itemMatrix;
    }

    public int getK() {
        return this.K;
    }
}

