/*
 * Decompiled with CFR 0.152.
 */
package es.uam.eps.ir.ranksys.mf.rec;

import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import es.uam.eps.ir.ranksys.fast.FastRecommendation;
import es.uam.eps.ir.ranksys.fast.index.FastItemIndex;
import es.uam.eps.ir.ranksys.fast.index.FastUserIndex;
import es.uam.eps.ir.ranksys.fast.utils.topn.IntDoubleTopN;
import es.uam.eps.ir.ranksys.mf.Factorization;
import es.uam.eps.ir.ranksys.rec.fast.AbstractFastRecommender;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.IntPredicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.ranksys.core.util.tuples.Tuple2id;
import org.ranksys.core.util.tuples.Tuples;

public class MFRecommender<U, I>
extends AbstractFastRecommender<U, I> {
    private final Factorization<U, I> factorization;

    public MFRecommender(FastUserIndex<U> uIndex, FastItemIndex<I> iIndex, Factorization<U, I> factorization) {
        super(uIndex, iIndex);
        this.factorization = factorization;
    }

    public FastRecommendation getRecommendation(int uidx, int maxLength, IntPredicate filter) {
        DoubleMatrix1D pu = this.factorization.getUserVector(this.uidx2user(uidx));
        if (pu == null) {
            return new FastRecommendation(uidx, new ArrayList());
        }
        IntDoubleTopN topN = new IntDoubleTopN(Math.min(maxLength, this.factorization.numItems()));
        DoubleMatrix1D r = this.factorization.getItemMatrix().zMult(pu, null);
        for (int iidx = 0; iidx < r.size(); ++iidx) {
            if (!filter.test(iidx)) continue;
            topN.add(iidx, r.getQuick(iidx));
        }
        topN.sort();
        List items = topN.reverseStream().collect(Collectors.toList());
        return new FastRecommendation(uidx, items);
    }

    public FastRecommendation getRecommendation(int uidx, IntStream candidates) {
        DoubleMatrix1D pu = this.factorization.getUserVector(this.uidx2user(uidx));
        if (pu == null) {
            return new FastRecommendation(uidx, new ArrayList());
        }
        DenseDoubleMatrix2D q = this.factorization.getItemMatrix();
        List items = candidates.mapToObj(iidx -> Tuples.tuple((int)iidx, (double)q.viewRow(iidx).zDotProduct(pu))).sorted(Comparator.comparingDouble(Tuple2id::v2).reversed()).collect(Collectors.toList());
        return new FastRecommendation(uidx, items);
    }
}

