/*
 * Decompiled with CFR 0.152.
 */
package es.uam.eps.ir.ranksys.novdiv.itemnovelty.metrics;

import es.uam.eps.ir.ranksys.core.Recommendation;
import es.uam.eps.ir.ranksys.core.model.UserModel;
import es.uam.eps.ir.ranksys.metrics.AbstractRecommendationMetric;
import es.uam.eps.ir.ranksys.metrics.rank.RankingDiscountModel;
import es.uam.eps.ir.ranksys.metrics.rel.RelevanceModel;
import es.uam.eps.ir.ranksys.novdiv.itemnovelty.ItemNovelty;
import org.ranksys.core.util.tuples.Tuple2od;

public abstract class ItemNoveltyMetric<U, I>
extends AbstractRecommendationMetric<U, I> {
    private final int cutoff;
    protected final ItemNovelty<U, I> novelty;
    private final RelevanceModel<U, I> relModel;
    private final RankingDiscountModel disc;

    public ItemNoveltyMetric(int cutoff, ItemNovelty<U, I> novelty, RelevanceModel<U, I> relevanceModel, RankingDiscountModel disc) {
        this.cutoff = cutoff;
        this.novelty = novelty;
        this.relModel = relevanceModel;
        this.disc = disc;
    }

    public double evaluate(Recommendation<U, I> recommendation) {
        Object u = recommendation.getUser();
        RelevanceModel.UserRelevanceModel userRelModel = this.relModel.getModel(u);
        UserModel.Model uinm = this.novelty.getModel(u);
        if (uinm == null) {
            return 0.0;
        }
        double nov = 0.0;
        double norm = 0.0;
        int rank = 0;
        for (Tuple2od iv : recommendation.getItems()) {
            nov += this.disc.disc(rank) * userRelModel.gain(iv.v1) * uinm.novelty(iv.v1);
            norm += this.disc.disc(rank);
            if (++rank < this.cutoff) continue;
            break;
        }
        if (norm > 0.0) {
            nov /= norm;
        }
        return nov;
    }
}

