/*
 * Decompiled with CFR 0.152.
 */
package es.uam.eps.ir.ranksys.novdiv.itemnovelty.reranking;

import es.uam.eps.ir.ranksys.core.Recommendation;
import es.uam.eps.ir.ranksys.core.model.UserModel;
import es.uam.eps.ir.ranksys.core.util.Stats;
import es.uam.eps.ir.ranksys.fast.utils.topn.IntDoubleTopN;
import es.uam.eps.ir.ranksys.novdiv.itemnovelty.ItemNovelty;
import es.uam.eps.ir.ranksys.novdiv.reranking.PermutationReranker;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleOpenHashMap;
import java.util.List;
import org.ranksys.core.util.tuples.Tuple2od;

public class ItemNoveltyReranker<U, I>
extends PermutationReranker<U, I> {
    private final double lambda;
    private final ItemNovelty<U, I> novelty;
    private final boolean norm;

    public ItemNoveltyReranker(double lambda, ItemNovelty<U, I> novelty, boolean norm) {
        this.lambda = lambda;
        this.novelty = novelty;
        this.norm = norm;
    }

    @Override
    public int[] rerankPermutation(Recommendation<U, I> recommendation, int maxLength) {
        Object user = recommendation.getUser();
        List items = recommendation.getItems();
        int M = items.size();
        int N = Math.min(maxLength, M);
        if (this.lambda == 0.0) {
            return ItemNoveltyReranker.getBasePerm(N);
        }
        UserModel.Model uinm = this.novelty.getModel(user);
        if (uinm == null) {
            return new int[0];
        }
        Object2DoubleOpenHashMap novMap = new Object2DoubleOpenHashMap();
        Stats relStats = new Stats();
        Stats novStats = new Stats();
        recommendation.getItems().forEach(arg_0 -> ItemNoveltyReranker.lambda$rerankPermutation$0((ItemNovelty.UserItemNoveltyModel)uinm, (Object2DoubleMap)novMap, relStats, novStats, arg_0));
        IntDoubleTopN topN = new IntDoubleTopN(N);
        for (int i = 0; i < M; ++i) {
            topN.add(M - i, this.value((Tuple2od<I>)((Tuple2od)items.get(i)), relStats, (Object2DoubleMap<I>)novMap, novStats));
        }
        topN.sort();
        return topN.reverseStream().mapToInt(e -> M - e.v1).toArray();
    }

    protected double norm(double score, Stats stats) {
        if (this.norm) {
            return (score - stats.getMean()) / stats.getStandardDeviation();
        }
        return score;
    }

    protected double value(Tuple2od<I> iv, Stats relStats, Object2DoubleMap<I> novMap, Stats novStats) {
        return (1.0 - this.lambda) * this.norm(iv.v2, relStats) + this.lambda * this.norm(novMap.getDouble(iv.v1), novStats);
    }

    private static /* synthetic */ void lambda$rerankPermutation$0(ItemNovelty.UserItemNoveltyModel uinm, Object2DoubleMap novMap, Stats relStats, Stats novStats, Tuple2od itemValue) {
        double nov = uinm.novelty(itemValue.v1);
        novMap.put(itemValue.v1, nov);
        relStats.accept(itemValue.v2);
        novStats.accept(nov);
    }
}

