/*
 * Decompiled with CFR 0.152.
 */
package es.uam.eps.ir.ranksys.novdiv.reranking;

import es.uam.eps.ir.ranksys.core.Recommendation;
import es.uam.eps.ir.ranksys.novdiv.reranking.PermutationReranker;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntLinkedOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSortedSet;
import java.util.List;
import java.util.stream.IntStream;
import org.ranksys.core.util.tuples.Tuple2od;

public abstract class GreedyReranker<U, I>
extends PermutationReranker<U, I> {
    protected final int cutoff;

    public GreedyReranker(int cutoff) {
        this.cutoff = cutoff;
    }

    @Override
    public int[] rerankPermutation(Recommendation<U, I> recommendation, int maxLength) {
        return this.getUserReranker(recommendation, maxLength).rerankPermutation();
    }

    protected abstract GreedyUserReranker<U, I> getUserReranker(Recommendation<U, I> var1, int var2);

    protected abstract class GreedyUserReranker<U, I> {
        protected final Recommendation<U, I> recommendation;
        protected final int maxLength;

        public GreedyUserReranker(Recommendation<U, I> recommendation, int maxLength) {
            this.recommendation = recommendation;
            this.maxLength = maxLength;
        }

        public int[] rerankPermutation() {
            List list = this.recommendation.getItems();
            IntArrayList perm = new IntArrayList();
            IntLinkedOpenHashSet remainingI = new IntLinkedOpenHashSet();
            IntStream.range(0, list.size()).forEach(i -> remainingI.add(i));
            while (!remainingI.isEmpty() && perm.size() < Math.min(this.maxLength, GreedyReranker.this.cutoff)) {
                int bestI = this.selectItem((IntSortedSet)remainingI, list);
                perm.add(bestI);
                remainingI.remove(bestI);
                this.update((Tuple2od)list.get(bestI));
            }
            while (perm.size() < Math.min(this.maxLength, list.size())) {
                perm.add(remainingI.removeFirstInt());
            }
            return perm.toIntArray();
        }

        protected int selectItem(IntSortedSet remainingI, List<Tuple2od<I>> list) {
            double[] max = new double[]{Double.NEGATIVE_INFINITY};
            int[] bestI = new int[]{remainingI.firstInt()};
            remainingI.forEach(i -> {
                double value = this.value((Tuple2od)list.get((int)i));
                if (Double.isNaN(value)) {
                    return;
                }
                if (value > max[0] || value == max[0] && i < bestI[0]) {
                    max[0] = value;
                    bestI[0] = i;
                }
            });
            return bestI[0];
        }

        protected abstract double value(Tuple2od<I> var1);

        protected abstract void update(Tuple2od<I> var1);
    }
}

