/*
 * Decompiled with CFR 0.152.
 */
package es.uam.eps.ir.ranksys.novdiv.reranking;

import es.uam.eps.ir.ranksys.core.Recommendation;
import es.uam.eps.ir.ranksys.core.util.Stats;
import es.uam.eps.ir.ranksys.novdiv.reranking.GreedyReranker;
import it.unimi.dsi.fastutil.ints.IntSortedSet;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleOpenHashMap;
import java.util.List;
import org.ranksys.core.util.tuples.Tuple2od;

public abstract class LambdaReranker<U, I>
extends GreedyReranker<U, I> {
    protected final double lambda;
    private final boolean norm;

    public LambdaReranker(double lambda, int cutoff, boolean norm) {
        super(cutoff);
        this.lambda = lambda;
        this.norm = norm;
    }

    @Override
    public int[] rerankPermutation(Recommendation<U, I> recommendation, int maxLength) {
        if (this.lambda == 0.0) {
            return LambdaReranker.getBasePerm(Math.min(maxLength, recommendation.getItems().size()));
        }
        return super.rerankPermutation(recommendation, maxLength);
    }

    @Override
    protected abstract GreedyReranker.GreedyUserReranker<U, I> getUserReranker(Recommendation<U, I> var1, int var2);

    protected abstract class LambdaUserReranker
    extends GreedyReranker.GreedyUserReranker<U, I> {
        protected Stats relStats;
        protected Stats novStats;
        protected Object2DoubleMap<I> novMap;

        public LambdaUserReranker(Recommendation<U, I> recommendation, int maxLength) {
            super(recommendation, maxLength);
        }

        protected double norm(double score, Stats stats) {
            if (LambdaReranker.this.norm) {
                return (score - stats.getMean()) / stats.getStandardDeviation();
            }
            return score;
        }

        @Override
        protected int selectItem(IntSortedSet remainingI, List<Tuple2od<I>> list) {
            this.novMap = new Object2DoubleOpenHashMap();
            this.relStats = new Stats();
            this.novStats = new Stats();
            remainingI.forEach(i -> {
                Tuple2od itemValue = (Tuple2od)list.get((int)i);
                double nov = this.nov(itemValue);
                this.novMap.put(itemValue.v1, nov);
                this.relStats.accept(itemValue.v2);
                this.novStats.accept(nov);
            });
            return super.selectItem(remainingI, list);
        }

        @Override
        protected double value(Tuple2od<I> iv) {
            return (1.0 - LambdaReranker.this.lambda) * this.norm(iv.v2, this.relStats) + LambdaReranker.this.lambda * this.norm(this.novMap.getDouble(iv.v1), this.novStats);
        }

        protected abstract double nov(Tuple2od<I> var1);
    }
}

