/*
 * Decompiled with CFR 0.152.
 */
package es.uam.eps.ir.ranksys.novdiv.reranking;

import es.uam.eps.ir.ranksys.core.Recommendation;
import es.uam.eps.ir.ranksys.fast.FastRecommendation;
import es.uam.eps.ir.ranksys.fast.index.FastItemIndex;
import es.uam.eps.ir.ranksys.fast.index.FastUserIndex;
import es.uam.eps.ir.ranksys.novdiv.reranking.Reranker;
import es.uam.eps.ir.ranksys.rec.fast.AbstractFastRecommender;
import es.uam.eps.ir.ranksys.rec.fast.FastRecommender;
import java.util.List;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class RerankingRecommender<U, I>
extends AbstractFastRecommender<U, I> {
    private final FastRecommender<U, I> recommender;
    private final Reranker<U, I> reranker;

    public RerankingRecommender(FastUserIndex<U> uIndex, FastItemIndex<I> iIndex, FastRecommender<U, I> recommender, Reranker<U, I> reranker) {
        super(uIndex, iIndex);
        this.recommender = recommender;
        this.reranker = reranker;
    }

    public Recommendation<U, I> getRecommendation(U u, int maxLength, Predicate<I> filter) {
        return this.reranker.rerankRecommendation(this.recommender.getRecommendation(u, filter), maxLength);
    }

    public FastRecommendation getRecommendation(int uidx, int maxLength, IntPredicate filter) {
        FastRecommendation frec = this.recommender.getRecommendation(uidx, filter);
        Object user = this.uidx2user(uidx);
        List items = frec.getIidxs().stream().map(arg_0 -> ((RerankingRecommender)this).iidx2item(arg_0)).collect(Collectors.toList());
        Recommendation<U, I> rec = new Recommendation<U, I>(user, items);
        rec = this.reranker.rerankRecommendation(rec, Math.min(maxLength, items.size()));
        List iidxs = rec.getItems().stream().map(arg_0 -> ((RerankingRecommender)this).item2iidx(arg_0)).collect(Collectors.toList());
        frec = new FastRecommendation(uidx, iidxs);
        return frec;
    }
}

