/*
 * Decompiled with CFR 0.152.
 */
package org.ranksys.novdiv.reranking;

import es.uam.eps.ir.ranksys.core.Recommendation;
import es.uam.eps.ir.ranksys.fast.utils.topn.IntDoubleTopN;
import es.uam.eps.ir.ranksys.novdiv.reranking.PermutationReranker;
import java.util.List;
import org.apache.commons.math3.distribution.NormalDistribution;

public class DitheringReranker<U, I>
extends PermutationReranker<U, I> {
    private final double variance;

    public DitheringReranker(double variance) {
        this.variance = variance;
    }

    @Override
    public int[] rerankPermutation(Recommendation<U, I> recommendation, int maxLength) {
        List items = recommendation.getItems();
        int M = items.size();
        int N = Math.min(maxLength, M);
        if (this.variance == 0.0) {
            return DitheringReranker.getBasePerm(N);
        }
        NormalDistribution dist = new NormalDistribution(0.0, Math.sqrt(this.variance));
        IntDoubleTopN topN = new IntDoubleTopN(N);
        for (int i = 0; i < M; ++i) {
            topN.add(M - i, Math.log(i + 1) + dist.sample());
        }
        topN.sort();
        return topN.stream().mapToInt(e -> M - e.v1).toArray();
    }
}

