/*
 * Decompiled with CFR 0.152.
 */
package es.uam.eps.ir.ranksys.novelty.inverted.br;

import es.uam.eps.ir.ranksys.core.Recommendation;
import es.uam.eps.ir.ranksys.novelty.inverted.br.BayesRuleReranker;
import es.uam.eps.ir.ranksys.rec.Recommender;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleOpenHashMap;
import java.util.stream.Stream;
import org.ranksys.core.util.tuples.Tuple2od;

public class AlphaBayesRuleReranker<U, I>
extends BayesRuleReranker<U, I> {
    private final double alpha;
    private final Object2DoubleMap<I> norm;

    public AlphaBayesRuleReranker(double alpha, Object2DoubleMap<I> norm) {
        this.alpha = alpha;
        this.norm = norm;
    }

    public AlphaBayesRuleReranker(double alpha, Stream<Recommendation<U, I>> recommendations) {
        this(alpha, AlphaBayesRuleReranker.calculateNorm(recommendations));
    }

    public AlphaBayesRuleReranker(double alpha, Stream<U> users, Recommender<U, I> recommender) {
        this(alpha, ((Stream)users.parallel()).map(u -> recommender.getRecommendation(u)));
    }

    public static <U, I> Object2DoubleMap<I> calculateNorm(Stream<Recommendation<U, I>> recommendations) {
        return (Object2DoubleMap)((Stream)recommendations.parallel()).flatMap(recommendation -> recommendation.getItems().stream()).collect(() -> new Object2DoubleOpenHashMap(), (m, iv) -> m.addTo(iv.v1, iv.v2), (m1, m2) -> m2.object2DoubleEntrySet().forEach(e -> m1.addTo(e.getKey(), e.getDoubleValue())));
    }

    @Override
    protected double likelihood(Tuple2od<I> iv) {
        return iv.v2 / (Double)this.norm.get(iv.v1);
    }

    @Override
    protected double prior(I i) {
        return Math.pow((Double)this.norm.get(i), 1.0 - this.alpha);
    }
}

