/*
 * Decompiled with CFR 0.152.
 */
package es.uam.eps.ir.ranksys.novelty.inverted.neighborhood;

import es.uam.eps.ir.ranksys.nn.neighborhood.Neighborhood;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.function.IntPredicate;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.ranksys.core.util.tuples.Tuple2id;
import org.ranksys.core.util.tuples.Tuples;

public class InvertedNeighborhood
implements Neighborhood {
    private final IntArrayList[] idxla;
    private final DoubleArrayList[] simla;

    public InvertedNeighborhood(int n, Neighborhood neighborhood, IntPredicate filter) {
        this.idxla = new IntArrayList[n];
        this.simla = new DoubleArrayList[n];
        IntStream.range(0, n).parallel().filter(filter).forEach(idx -> {
            this.idxla[idx] = new IntArrayList();
            this.simla[idx] = new DoubleArrayList();
        });
        IntStream.range(0, n).parallel().mapToObj(idx -> Tuples.tuple((int)idx, (Object)neighborhood.getNeighbors(idx))).forEachOrdered(in -> {
            int idx = in.v1;
            ((Stream)in.v2).forEach(is -> {
                if (this.idxla[is.v1] != null) {
                    this.idxla[is.v1].add(idx);
                    this.simla[is.v1].add(is.v2);
                }
            });
        });
    }

    public Stream<Tuple2id> getNeighbors(int idx) {
        IntArrayList idxl = this.idxla[idx];
        DoubleArrayList siml = this.simla[idx];
        return IntStream.range(0, idxl.size()).mapToObj(i -> Tuples.tuple((int)idxl.getInt(i), (double)siml.getDouble(i)));
    }
}

