/*
 * Decompiled with CFR 0.152.
 */
package es.uam.eps.ir.ranksys.novelty.longtail;

import es.uam.eps.ir.ranksys.core.preference.PreferenceData;
import es.uam.eps.ir.ranksys.novdiv.itemnovelty.ItemNovelty;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleOpenHashMap;
import java.util.IntSummaryStatistics;

public class FDItemNovelty<U, I>
extends ItemNovelty<U, I> {
    private final UserFDItemNoveltyModel nov;

    public FDItemNovelty(PreferenceData<U, I> recommenderData) {
        this.nov = new UserFDItemNoveltyModel(recommenderData);
    }

    protected ItemNovelty.UserItemNoveltyModel<U, I> get(U t) {
        return this.nov;
    }

    public ItemNovelty.UserItemNoveltyModel<U, I> getModel(U u) {
        return this.nov;
    }

    private class UserFDItemNoveltyModel
    implements ItemNovelty.UserItemNoveltyModel<U, I> {
        private final Object2DoubleMap<I> itemNovelty;

        public UserFDItemNoveltyModel(PreferenceData<U, I> recommenderData) {
            IntSummaryStatistics stats = recommenderData.getItemsWithPreferences().mapToInt(i -> recommenderData.numUsers(i)).summaryStatistics();
            double norm = stats.getSum();
            double maxNov = -Math.log((double)stats.getMin() / norm) / Math.log(2.0);
            this.itemNovelty = new Object2DoubleOpenHashMap();
            this.itemNovelty.defaultReturnValue(maxNov);
            recommenderData.getItemsWithPreferences().forEach(i -> this.itemNovelty.put(i, -Math.log((double)recommenderData.numUsers(i) / norm) / Math.log(2.0)));
        }

        public double novelty(I i) {
            return this.itemNovelty.getDouble(i);
        }
    }
}

