/*
 * Decompiled with CFR 0.152.
 */
package es.uam.eps.ir.ranksys.novelty.sales;

import es.uam.eps.ir.ranksys.metrics.rank.RankingDiscountModel;
import es.uam.eps.ir.ranksys.novdiv.itemnovelty.ItemNovelty;
import java.util.List;
import java.util.function.Function;

public class ISDCItemNovelty<U, I>
extends ItemNovelty<U, I> {
    private final int nSystems;
    private final Function<U, List<List<I>>> otherUserRecommendations;
    private final RankingDiscountModel disc;

    public ISDCItemNovelty(int nSystems, Function<U, List<List<I>>> otherUserRecommendations, RankingDiscountModel disc) {
        super(false, null);
        this.nSystems = nSystems;
        this.otherUserRecommendations = otherUserRecommendations;
        this.disc = disc;
    }

    protected ItemNovelty.UserItemNoveltyModel<U, I> get(U u) {
        return new UserISDCItemNoveltyModel(this.otherUserRecommendations.apply(u));
    }

    private class UserISDCItemNoveltyModel
    implements ItemNovelty.UserItemNoveltyModel<U, I> {
        private final List<List<I>> otherRecommendations;

        public UserISDCItemNoveltyModel(List<List<I>> otherRecommendations) {
            this.otherRecommendations = otherRecommendations;
        }

        public double novelty(I i) {
            if (this.otherRecommendations == null) {
                return 1.0;
            }
            double nov = this.otherRecommendations.stream().mapToDouble(list -> {
                int k = list.indexOf(i);
                if (k == -1) {
                    return 1.0;
                }
                return 1.0 - ISDCItemNovelty.this.disc.disc(k);
            }).sum();
            return nov /= (double)ISDCItemNovelty.this.nSystems;
        }
    }
}

