/*
 * Decompiled with CFR 0.152.
 */
package es.uam.eps.ir.ranksys.novelty.temporal;

import es.uam.eps.ir.ranksys.metrics.rank.RankingDiscountModel;
import es.uam.eps.ir.ranksys.novdiv.itemnovelty.ItemNovelty;
import java.util.List;
import java.util.function.Function;

public class TDItemNovelty<U, I>
extends ItemNovelty<U, I> {
    private final Function<U, List<I>> pastRecommendations;
    private final RankingDiscountModel disc;

    public TDItemNovelty(Function<U, List<I>> pastRecommendations, RankingDiscountModel disc) {
        this.pastRecommendations = pastRecommendations;
        this.disc = disc;
    }

    protected ItemNovelty.UserItemNoveltyModel<U, I> get(U u) {
        List<I> lastRecommendation = this.pastRecommendations.apply(u);
        if (lastRecommendation == null) {
            return null;
        }
        return new UserTimeItemNoveltyModel(lastRecommendation);
    }

    private class UserTimeItemNoveltyModel
    implements ItemNovelty.UserItemNoveltyModel<U, I> {
        private final List<I> lastRecommendation;

        public UserTimeItemNoveltyModel(List<I> lastRecommendation) {
            this.lastRecommendation = lastRecommendation;
        }

        public double novelty(I i) {
            int k = this.lastRecommendation.indexOf(i);
            if (k == -1) {
                return 1.0;
            }
            return 1.0 - TDItemNovelty.this.disc.disc(k);
        }
    }
}

