/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.plugin.app;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.Maven;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.DefaultArtifactRepository;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.artifact.repository.layout.DefaultRepositoryLayout;
import org.apache.maven.cli.MavenCli;
import org.apache.maven.execution.DefaultMavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionRequestPopulator;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.execution.MavenSession;
import org.codehaus.plexus.PlexusContainer;
import org.rapidoid.u.U;

public class EmbeddedMavenCli
extends MavenCli {
    private final MavenSession session;

    public EmbeddedMavenCli(MavenSession session) {
        this.session = session;
    }

    public void execute(List<String> goals, String baseDirectory, boolean updateSnapshots, Map<String, String> properties) {
        try {
            this.executeReq(goals, baseDirectory, updateSnapshots, properties);
        }
        catch (Exception e) {
            throw U.rte((Throwable)e);
        }
    }

    private void executeReq(List<String> goals, String baseDirectory, boolean updateSnapshots, Map<String, String> properties) throws Exception {
        Iterator iterator;
        MavenExecutionResult result;
        PlexusContainer container = this.session.getContainer();
        Maven maven = (Maven)container.lookup(Maven.class);
        MavenExecutionRequestPopulator executionRequestPopulator = (MavenExecutionRequestPopulator)container.lookup(MavenExecutionRequestPopulator.class);
        DefaultMavenExecutionRequest request = new DefaultMavenExecutionRequest();
        request = executionRequestPopulator.populateDefaults((MavenExecutionRequest)request);
        request.setPom(this.session.getRequest().getPom());
        request.setGoals(goals);
        request.setUpdateSnapshots(updateSnapshots);
        request.setBaseDirectory(new File(baseDirectory));
        Properties props = new Properties();
        props.putAll(properties);
        request.setUserProperties(props);
        String localRepo = System.getProperty("maven.repo.local");
        if (localRepo != null) {
            request.setLocalRepositoryPath(localRepo);
            DefaultRepositoryLayout layout = new DefaultRepositoryLayout();
            DefaultArtifactRepository repo = new DefaultArtifactRepository("repo", "file://" + localRepo, (ArtifactRepositoryLayout)layout);
            request.setLocalRepository((ArtifactRepository)repo);
            props.put("maven.repo.local", localRepo);
        }
        if ((result = maven.execute((MavenExecutionRequest)request)).hasExceptions() && (iterator = result.getExceptions().iterator()).hasNext()) {
            Throwable e = (Throwable)iterator.next();
            throw U.rte((Throwable)e);
        }
    }
}

