/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.plugin.app;

import java.util.List;
import java.util.Map;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.rapidoid.commons.Str;
import org.rapidoid.config.ConfigImpl;
import org.rapidoid.http.HTTP;
import org.rapidoid.io.IO;
import org.rapidoid.io.Upload;
import org.rapidoid.log.Log;
import org.rapidoid.plugin.app.AbstractRapidoidMojo;
import org.rapidoid.u.U;
import org.rapidoid.util.Msc;

@Mojo(name="deploy", aggregator=true, defaultPhase=LifecyclePhase.DEPLOY)
public class AppDeployMojo
extends AbstractRapidoidMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    protected MavenSession session;
    @Parameter(defaultValue="${token}")
    protected String token = "";
    @Parameter(defaultValue="${servers}")
    protected String servers = "";

    public void execute() throws MojoExecutionException {
        Msc.setMavenBuild((boolean)true);
        this.initConfig();
        String uberJar = this.buildUberJar(this.project, this.session);
        this.deploy(uberJar);
    }

    protected void deploy(String uberJar) throws MojoExecutionException {
        this.validateConfig();
        List<String> targetServers = this.getServers();
        this.getLog().info((CharSequence)U.frmt((String)"Deploying the uber-jar to %s servers...", (Object[])new Object[]{targetServers.size()}));
        this.getLog().info((CharSequence)"");
        Upload jar = new Upload("app.jar", IO.loadBytes((String)uberJar));
        boolean ok = true;
        for (String server : targetServers) {
            ok &= this.doStage(jar, server + "/rapidoid/stage");
        }
        this.failIf(!ok, "The staging failed on at least 1 server. Aborting the deployment!", new Object[0]);
        for (String server : targetServers) {
            this.doDeploy(server + "/rapidoid/deploy");
        }
    }

    private void validateConfig() throws MojoExecutionException {
        if (U.isEmpty((String)this.servers)) {
            this.servers = "localhost";
            Log.warn((String)"No 'servers' were configured, using 'localhost' as default");
        }
        if (U.isEmpty((String)this.token)) {
            this.token = "";
            Log.warn((String)"No 'token' was configured, using empty token as default");
        }
    }

    private List<String> getServers() {
        Object[] srvrs = this.servers.split("\\s*,\\s*");
        for (int i = 0; i < srvrs.length; ++i) {
            String server = Str.trimr((String)srvrs[i], (String)"/");
            if (!server.startsWith("http")) {
                server = "http://" + server;
            }
            srvrs[i] = server;
        }
        return U.list((Object[])srvrs);
    }

    private void initConfig() {
        ConfigImpl config = new ConfigImpl("deploy");
        config.setPath(this.project.getBasedir().toString());
        Map cfg = config.toMap();
        if (U.isEmpty((String)this.token)) {
            this.token = U.safe((String)U.str(cfg.get("token")));
        }
        if (U.isEmpty((String)this.servers)) {
            Object srvrs = cfg.get("servers");
            if (srvrs instanceof String) {
                this.servers = (String)srvrs;
            } else if (srvrs instanceof List) {
                List list = (List)srvrs;
                this.servers = U.join((String)", ", (Iterable)list);
            }
        }
    }

    private boolean doStage(Upload jar, String url) {
        this.getLog().info((CharSequence)(" - uploading / staging the uber-jar to: " + url));
        return this.request(HTTP.post((String)url).data("_token", (Object)this.token).file("file", U.list((Object[])new Upload[]{jar})));
    }

    private boolean doDeploy(String url) {
        this.getLog().info((CharSequence)(" - deploying the staged application on: " + url));
        return this.request(HTTP.post((String)url).data("_token", (Object)this.token));
    }
}

