/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.plugin.app;

import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javassist.Modifier;
import javassist.bytecode.ClassFile;
import javassist.bytecode.MethodInfo;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.MavenInvocationException;
import org.rapidoid.http.HttpReq;
import org.rapidoid.http.HttpResp;
import org.rapidoid.io.IO;
import org.rapidoid.lambda.Predicate;
import org.rapidoid.scan.Scan;
import org.rapidoid.u.U;
import org.rapidoid.util.Msc;

public abstract class AbstractRapidoidMojo
extends AbstractMojo {
    protected static final String ABORT = "Aborting the build!";

    protected void failIf(boolean failureCondition, String msg, Object ... args) throws MojoExecutionException {
        if (failureCondition) {
            throw new MojoExecutionException(U.frmt((String)msg, (Object[])args));
        }
    }

    protected boolean request(HttpReq req) {
        HttpResp resp = req.execute();
        switch (resp.code()) {
            case 200: {
                return true;
            }
            case 404: {
                this.getLog().error((CharSequence)U.frmt((String)"Couldn't find: %s", (Object[])new Object[]{req.url()}));
                return false;
            }
        }
        String msg = "Unexpected response received from: %s! Response code: %s, full response:\n\n%s\n";
        this.getLog().error((CharSequence)U.frmt((String)msg, (Object[])new Object[]{req.url(), resp.code(), resp.body()}));
        return false;
    }

    protected String createTempFile(String prefix, String suffix, FileAttribute<?> ... attrs) throws MojoExecutionException {
        String assemblyFile;
        try {
            assemblyFile = Files.createTempFile(prefix, suffix, attrs).toAbsolutePath().toString();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Couldn't create temporary file! Aborting the build!", (Exception)e);
        }
        return assemblyFile;
    }

    protected String createTempDir(String prefix, FileAttribute<?> ... attrs) throws MojoExecutionException {
        String assemblyFile;
        try {
            assemblyFile = Files.createTempDirectory(prefix, attrs).toAbsolutePath().toString();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Couldn't create temporary directory! Aborting the build!", (Exception)e);
        }
        return assemblyFile;
    }

    protected void invoke(MavenSession session, List<String> goals, boolean updateSnapshots, Map<String, String> properties) throws MojoExecutionException {
        this.invokeInstalled(session, goals, updateSnapshots, properties);
    }

    protected void invokeInstalled(MavenSession session, List<String> goals, boolean updateSnapshots, Map<String, String> properties) throws MojoExecutionException {
        boolean success;
        DefaultInvocationRequest request = new DefaultInvocationRequest();
        request.setPomFile(session.getRequest().getPom());
        request.setGoals(goals);
        request.setAlsoMake(true);
        request.setUpdateSnapshots(updateSnapshots);
        Properties props = new Properties();
        props.putAll(properties);
        request.setProperties(props);
        DefaultInvoker invoker = new DefaultInvoker();
        try {
            InvocationResult result = invoker.execute((InvocationRequest)request);
            success = result.getExitCode() == 0 && result.getExecutionException() == null;
        }
        catch (MavenInvocationException e) {
            throw new MojoExecutionException("Invocation error! Aborting the build!", (Exception)((Object)e));
        }
        this.failIf(!success, "An error occurred. Aborting the build!", new Object[0]);
    }

    protected String buildUberJar(MavenProject project, MavenSession session) throws MojoExecutionException {
        List appJars;
        List goals = U.list((Object[])new String[]{"package", "org.apache.maven.plugins:maven-assembly-plugin:2.6:single"});
        String assemblyFile = this.createTempFile("app-assembly-", ".xml", new FileAttribute[0]);
        IO.save((String)assemblyFile, (String)IO.load((String)"uber-jar.xml"));
        Map properties = U.map();
        properties.put("skipTests", "true");
        properties.put("descriptor", assemblyFile);
        properties.put("assembly.appendAssemblyId", "true");
        properties.put("assembly.attach", "false");
        this.invoke(session, goals, false, properties);
        boolean deleted = new File(assemblyFile).delete();
        if (!deleted) {
            this.getLog().warn((CharSequence)"Couldn't delete the temporary assembly descriptor file!");
        }
        this.failIf((appJars = IO.find((String)"*-uber-jar.jar").in(project.getBuild().getDirectory()).getNames()).size() != 1, "Cannot find the deployment JAR (found %s candidates)! Aborting the build!", appJars.size());
        String uberJar = (String)U.first((List)appJars);
        try {
            Path uberJarPath = Paths.get(uberJar, new String[0]);
            Path appJar = uberJarPath.getParent().resolve("app.jar");
            Files.move(uberJarPath, appJar, StandardCopyOption.REPLACE_EXISTING);
            uberJar = appJar.toFile().getAbsolutePath();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Couldn't rename the file! Aborting the build!", (Exception)e);
        }
        String mainClass = this.findMainClass(project);
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)("The main class is: " + mainClass));
        try {
            this.addJarManifest(uberJar, project, mainClass);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Couldn't add the JAR manifest! Aborting the build!", (Exception)e);
        }
        String size = Msc.fileSizeReadable((String)uberJar);
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)"Successfully packaged the application with dependencies:");
        this.getLog().info((CharSequence)U.frmt((String)"%s (size: %s).", (Object[])new Object[]{uberJar, size}));
        this.getLog().info((CharSequence)"");
        return uberJar;
    }

    private void addJarManifest(String uberJar, MavenProject project, String mainClass) throws IOException {
        Path path = Paths.get(uberJar, new String[0]);
        URI uri = URI.create("jar:" + path.toUri());
        String user = System.getProperty("user.name");
        String manifestContent = IO.load((String)"manifest-template.mf").replace("$user", user).replace("$java", Msc.javaVersion()).replace("$name", project.getName()).replace("$version", project.getVersion()).replace("$groupId", project.getGroupId()).replace("$organization", project.getOrganization() != null ? (String)U.or((Object)project.getOrganization().getName(), (Object)"?") : "?").replace("$url", (CharSequence)U.or((Object)project.getUrl(), (Object)"?")).replace("$main", U.safe((String)mainClass));
        try (FileSystem fs = FileSystems.newFileSystem(uri, U.map());){
            Path manifest = fs.getPath("META-INF/MANIFEST.MF", new String[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(manifest, StandardCharsets.UTF_8, StandardOpenOption.CREATE);){
                writer.write(manifestContent);
            }
        }
    }

    protected String findMainClass(MavenProject project) {
        List mainClasses = U.list();
        try {
            for (String path : project.getCompileClasspathElements()) {
                if (new File(path).isDirectory()) {
                    this.getLog().info((CharSequence)("Scanning classpath directory: " + path));
                    AbstractRapidoidMojo.scanForMainClass(path, mainClasses);
                    continue;
                }
                if (path.endsWith(".jar")) continue;
                this.getLog().warn((CharSequence)("Ignoring classpath entry: " + path));
            }
        }
        catch (Exception e) {
            throw U.rte((Throwable)e);
        }
        switch (mainClasses.size()) {
            case 0: {
                this.getLog().warn((CharSequence)"Couldn't find the main class!");
                return null;
            }
            case 1: {
                return (String)U.first((List)mainClasses);
            }
        }
        this.getLog().warn((CharSequence)("Found multiple main classes, trying to pick the right one: " + mainClasses));
        return this.pickMainClass(mainClasses, project);
    }

    private String pickMainClass(List<String> mainClasses, MavenProject project) {
        String byGroupId = project.getGroupId() + ".Main";
        if (mainClasses.contains(byGroupId)) {
            return byGroupId;
        }
        List namedMain = U.list();
        List withGroupIdPkg = U.list();
        for (String name : mainClasses) {
            if (name.equals("Main")) {
                return "Main";
            }
            if (name.endsWith(".Main")) {
                namedMain.add(name);
            }
            if (!name.startsWith(project.getGroupId() + ".")) continue;
            withGroupIdPkg.add(name);
        }
        this.getLog().info((CharSequence)("Candidates by group ID: " + withGroupIdPkg));
        if (withGroupIdPkg.size() == 1) {
            return (String)U.single((Iterable)withGroupIdPkg);
        }
        this.getLog().info((CharSequence)("Candidates named Main: " + namedMain));
        if (namedMain.size() == 1) {
            return (String)U.single((Iterable)namedMain);
        }
        namedMain.retainAll(withGroupIdPkg);
        this.getLog().info((CharSequence)("Candidates by group ID - named Main: " + namedMain));
        if (namedMain.size() == 1) {
            return (String)U.single((Iterable)namedMain);
        }
        Collections.sort(withGroupIdPkg, new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                return s1.length() - s2.length();
            }
        });
        this.getLog().info((CharSequence)("Candidates by group ID - picking one with the shortest name: " + withGroupIdPkg));
        return (String)U.first((List)withGroupIdPkg);
    }

    private static void scanForMainClass(String path, Collection<String> mainClasses) {
        mainClasses.addAll(Scan.classpath((String[])new String[]{path}).bytecodeFilter((Predicate)new Predicate<InputStream>(){

            public boolean eval(InputStream input) throws Exception {
                return AbstractRapidoidMojo.hasMainMethod(new ClassFile(new DataInputStream(input)));
            }
        }).getAll());
    }

    private static boolean hasMainMethod(ClassFile cls) {
        int flags = cls.getAccessFlags();
        if (Modifier.isInterface((int)flags) || Modifier.isAnnotation((int)flags) || Modifier.isEnum((int)flags)) {
            return false;
        }
        for (Object m : cls.getMethods()) {
            if (!(m instanceof MethodInfo) || !AbstractRapidoidMojo.isMainMethod((MethodInfo)m)) continue;
            return true;
        }
        return false;
    }

    private static boolean isMainMethod(MethodInfo method) {
        int flags = method.getAccessFlags();
        return method.getName().equals("main") && Modifier.isPublic((int)flags) && Modifier.isStatic((int)flags) && U.eq((Object)method.getDescriptor(), (Object)"([Ljava/lang/String;)V");
    }
}

