/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.activity;

import org.rapidoid.activity.LifecycleActivity;
import org.rapidoid.util.U;

public abstract class AbstractThreadActivity<T>
extends LifecycleActivity<T>
implements Runnable {
    protected final Thread thread;

    public AbstractThreadActivity(String name) {
        super(name);
        this.thread = new Thread((Runnable)this, name);
    }

    @Override
    public T start() {
        this.checkActive(false);
        this.thread.start();
        return super.start();
    }

    @Override
    public T halt() {
        this.checkActive(true);
        this.thread.stop();
        U.joinThread((Thread)this.thread);
        return super.halt();
    }

    @Override
    public T shutdown() {
        this.checkActive(true);
        this.thread.interrupt();
        U.joinThread((Thread)this.thread);
        return super.shutdown();
    }

    @Override
    public final void run() {
        U.info((String)"Starting activity thread", (String)"name", (Object)this.name);
        try {
            while (!Thread.interrupted()) {
                try {
                    this.loop();
                }
                catch (Exception e) {
                    U.error((String)"Worker processing error!", (String)"activity", (Object)this.name, (String)"error", (Object)e);
                }
            }
        }
        catch (ThreadDeath e) {
            U.info((String)"Halted activity thread", (String)"name", (Object)this.name);
            return;
        }
        U.info((String)"Finished activity thread", (String)"name", (Object)this.name);
    }

    protected abstract void loop();
}

