/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.beany;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.rapidoid.annotation.Display;
import org.rapidoid.beany.BeanProp;
import org.rapidoid.beany.BeanProperties;
import org.rapidoid.beany.MapProp;
import org.rapidoid.beany.Prop;
import org.rapidoid.beany.SerializableBean;
import org.rapidoid.lambda.Mapper;
import org.rapidoid.util.Cls;
import org.rapidoid.util.Exportable;
import org.rapidoid.util.TypeKind;
import org.rapidoid.util.U;
import org.rapidoid.util.UTILS;
import org.rapidoid.var.Vars;

public class Beany {
    private static final String GETTER = "^(get|is)[A-Z].*";
    private static final String SETTER = "^set[A-Z].*";
    protected static final Map<Class<?>, BeanProperties> BEAN_PROPERTIES = UTILS.autoExpandingMap((Mapper)new Mapper<Class<?>, BeanProperties>(){

        public BeanProperties map(Class<?> clazz) throws Exception {
            LinkedHashMap properties = new LinkedHashMap();
            Beany.getBeanProperties(clazz, properties);
            for (Map.Entry e : properties.entrySet()) {
                ((BeanProp)e.getValue()).init();
            }
            return new BeanProperties(properties);
        }
    });

    private static void getBeanProperties(Class<?> clazz, Map<String, BeanProp> properties) {
        if (clazz == null || clazz == Object.class) {
            return;
        }
        Beany.getBeanProperties(clazz.getSuperclass(), properties);
        for (Class<?> interf : clazz.getInterfaces()) {
            Beany.getBeanProperties(interf, properties);
        }
        if (Proxy.isProxyClass(clazz)) {
            return;
        }
        try {
            Field[] fields;
            Method[] methods;
            for (Method method : methods = clazz.getDeclaredMethods()) {
                BeanProp prop;
                String propName;
                int modif = method.getModifiers();
                Class<?>[] params = method.getParameterTypes();
                Class<?> ret = method.getReturnType();
                if ((modif & 2) != 0 || (modif & 4) != 0 || (modif & 8) != 0) continue;
                String name = method.getName();
                if (name.matches(GETTER) && params.length == 0 || name.matches(SETTER) && params.length == 1) {
                    propName = name.startsWith("is") ? name.substring(2, 3).toLowerCase() + name.substring(3) : name.substring(3, 4).toLowerCase() + name.substring(4);
                    prop = properties.get(propName);
                    if (prop == null) {
                        prop = new BeanProp(propName);
                        properties.put(propName, prop);
                    }
                    if (name.startsWith("set")) {
                        prop.setSetter(method);
                        prop.setReadOnly(false);
                        continue;
                    }
                    prop.setGetter(method);
                    continue;
                }
                if (name.matches("^to[A-Z].*") || name.equals("hashCode")) continue;
                if (params.length == 0 && !ret.equals(Void.TYPE)) {
                    propName = name;
                    prop = properties.get(propName);
                    if (prop == null) {
                        prop = new BeanProp(propName);
                        properties.put(propName, prop);
                    }
                    prop.setGetter(method);
                    continue;
                }
                if (params.length != 1) continue;
                propName = name;
                prop = properties.get(propName);
                if (prop == null) {
                    prop = new BeanProp(propName);
                    properties.put(propName, prop);
                }
                prop.setReadOnly(false);
                prop.setSetter(method);
            }
            Iterator<Map.Entry<String, BeanProp>> it = properties.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, BeanProp> entry = it.next();
                BeanProp minfo = entry.getValue();
                if (minfo.getGetter() != null || minfo.getSetter() == null) continue;
                it.remove();
            }
            for (Field field : fields = clazz.getDeclaredFields()) {
                String fieldName;
                BeanProp prop;
                int modif = field.getModifiers();
                if ((modif & 2) != 0 || (modif & 4) != 0 || (modif & 8) != 0 || (prop = properties.get(fieldName = field.getName())) != null) continue;
                prop = new BeanProp(fieldName, field, (modif & 0x10) != 0);
                properties.put(fieldName, prop);
            }
        }
        catch (Exception e) {
            throw U.rte((Throwable)e);
        }
    }

    public static void reset() {
        BEAN_PROPERTIES.clear();
    }

    public static BeanProperties propertiesOf(Class<?> clazz) {
        return BEAN_PROPERTIES.get(clazz);
    }

    public static BeanProperties propertiesOf(Object obj) {
        if (obj == null) {
            return BeanProperties.NONE;
        }
        if (obj instanceof Map) {
            return BeanProperties.from((Map)obj);
        }
        if (obj instanceof Class) {
            return Beany.propertiesOf((Class)obj);
        }
        return Beany.propertiesOf(obj.getClass());
    }

    public static Prop property(Class<?> clazz, String property, boolean mandatory) {
        Prop prop = BEAN_PROPERTIES.get(clazz).get(property);
        if (mandatory && prop == null) {
            throw U.rte((String)"Cannot find the property '%s' in the class '%s'", (Object[])new Object[]{property, clazz});
        }
        return prop;
    }

    public static Object serialize(Object value) {
        if (Cls.kindOf((Object)value) != TypeKind.OBJECT || value instanceof Enum) {
            return value;
        }
        if (value instanceof Set) {
            Set set = U.set((Object[])new Object[0]);
            for (Object item : (Set)value) {
                set.add(Beany.serialize(item));
            }
            return set;
        }
        if (value instanceof List) {
            List list = U.list((Object[])new Object[0]);
            for (Object item : (List)value) {
                list.add(Beany.serialize(item));
            }
            return list;
        }
        if (value instanceof Object[]) {
            Object[] vals = (Object[])value;
            Object[] arr = new Object[vals.length];
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = Beany.serialize(vals[i]);
            }
            return arr;
        }
        if (value instanceof Map) {
            Map map = U.map();
            for (Map.Entry e : ((Map)value).entrySet()) {
                map.put(Beany.serialize(e.getKey()), Beany.serialize(e.getValue()));
            }
            return map;
        }
        if (value.getClass().isArray()) {
            return value;
        }
        return Beany.read(value);
    }

    public static Map<String, Object> read(Object bean) {
        Map props = U.map();
        Beany.read(bean, props);
        return props;
    }

    public static void read(Object bean, Map<String, Object> dest) {
        U.notNull((Object)bean, (String)"bean", (Object[])new Object[0]);
        U.must((!(bean instanceof Collection) ? 1 : 0) != 0);
        U.must((!bean.getClass().isArray() ? 1 : 0) != 0);
        U.must((!bean.getClass().isEnum() ? 1 : 0) != 0);
        U.must((Cls.kindOf((Object)bean) == TypeKind.OBJECT ? 1 : 0) != 0);
        if (bean instanceof Exportable) {
            Exportable exportable = (Exportable)bean;
            exportable.exportTo(UTILS.importExport(dest));
            return;
        }
        for (Prop prop : Beany.propertiesOf(bean)) {
            Object value = prop.getRaw(bean);
            if (value instanceof SerializableBean) {
                SerializableBean ser = (SerializableBean)value;
                value = ser.serializeBean();
            } else {
                value = Beany.serialize(Beany.unwrap(value));
            }
            dest.put(prop.getName(), value);
        }
    }

    public static void update(Object destBean, Map<String, Object> src, boolean ignoreNullValues) {
        if (destBean instanceof Map) {
            ((Map)destBean).putAll(src);
            return;
        }
        for (Prop prop : Beany.propertiesOf(destBean)) {
            Object value = src.get(prop.getName());
            if (value == null && ignoreNullValues) continue;
            Object propValue = prop.getRaw(destBean);
            if (propValue != null && propValue instanceof SerializableBean) {
                SerializableBean ser = (SerializableBean)propValue;
                ser.deserializeBean(value);
                continue;
            }
            prop.set(destBean, value);
        }
    }

    public static Prop property(Object obj, String property, boolean mandatory) {
        if (obj instanceof Map) {
            Object value = ((Map)obj).get(property);
            return new MapProp(property, property, Cls.of(value));
        }
        return Beany.property(obj.getClass(), property, mandatory);
    }

    public static boolean hasProperty(Class<?> clazz, String property) {
        return Beany.property(clazz, property, false) != null;
    }

    public static boolean hasProperty(Object obj, String property) {
        return Beany.property(obj, property, false) != null;
    }

    public static void setPropValue(Object instance, String propertyName, Object value) {
        if (instance instanceof Map) {
            ((Map)instance).put(propertyName, value);
        } else {
            Beany.property(instance, propertyName, true).set(instance, value);
        }
    }

    public static <T> T getPropValue(Object instance, String propertyName, T defaultValue) {
        if (instance instanceof Map) {
            Map map = (Map)instance;
            return (T)(map.containsKey(propertyName) ? map.get(propertyName) : defaultValue);
        }
        Prop prop = Beany.property(instance, propertyName, false);
        return prop != null ? prop.get(instance) : defaultValue;
    }

    public static <T> T getPropValue(Object instance, String propertyName) {
        if (instance instanceof Map) {
            Map map = (Map)instance;
            U.must((boolean)map.containsKey(propertyName), (String)"The map must contain key: %s", (Object)propertyName);
            return (T)map.get(propertyName);
        }
        return Beany.property(instance, propertyName, true).get(instance);
    }

    public static <T> T getPropValueOfType(Object obj, String property, Class<T> returnType) {
        T value = Beany.getPropValueOfType(obj, property, returnType, null);
        if (value == null) {
            throw U.rte((String)"The property '%s' cannot be null!", (Object[])new Object[]{property});
        }
        return value;
    }

    public static <T> T getPropValueOfType(Object obj, String property, Class<T> returnType, T defaultValue) {
        Object id = Beany.getPropValue(obj, property, null);
        return (T)(id != null ? Cls.convert(id, returnType) : defaultValue);
    }

    public static void setId(Object obj, long id) {
        Beany.setPropValue(obj, "id", id);
    }

    public static long getId(Object obj) {
        return Beany.getPropValueOfType(obj, "id", Long.class);
    }

    public static Long getIdIfExists(Object obj) {
        return Beany.getPropValueOfType(obj, "id", Long.class, null);
    }

    public static long[] getIds(Object ... objs) {
        long[] ids = new long[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            ids[i] = Beany.getId(objs[i]);
        }
        return ids;
    }

    public static String beanToStr(Object bean, boolean allowCustom) {
        Method m;
        Class clazz = Cls.unproxy(bean.getClass());
        if (allowCustom && !(m = Cls.getMethod((Class)clazz, (String)"toString", (Class[])new Class[0])).getDeclaringClass().equals(Object.class)) {
            return bean.toString();
        }
        BeanProperties props = Beany.propertiesOf(bean).annotated(Display.class);
        boolean annotated = true;
        if (props.isEmpty()) {
            Prop nameProp = Beany.property(bean, "name", false);
            if (nameProp != null && nameProp.getType() == String.class) {
                return (String)U.or((Object)((String)nameProp.get(bean)), (Object)"");
            }
            annotated = false;
            props = Beany.propertiesOf(bean);
        }
        StringBuilder sb = new StringBuilder();
        for (Prop prop : props) {
            Object value;
            String name = prop.getName();
            if (!annotated && (name.equalsIgnoreCase("id") || name.equalsIgnoreCase("version") || prop.getTypeKind() == TypeKind.OBJECT || prop.getTypeKind() == TypeKind.DATE) || (value = prop.get(bean)) == null) continue;
            if (sb.length() > 0) {
                sb.append(", ");
            }
            if (value instanceof Number) {
                value = name + ": " + value;
            }
            sb.append(value);
        }
        return sb.toString();
    }

    public static <E> Comparator<E> comparator(String orderBy) {
        final int sign = orderBy.startsWith("-") ? -1 : 1;
        final String order = sign == 1 ? orderBy : orderBy.substring(1);
        Comparator comparator = new Comparator<E>(){

            @Override
            public int compare(E o1, E o2) {
                Object val1 = Beany.getPropValue(o1, order);
                Object val2 = Beany.getPropValue(o2, order);
                U.must((val1 == null || val1 instanceof Comparable ? 1 : 0) != 0, (String)"The property '%s' (%s) is not comparable!", (Object)order, (Object)Cls.of(val1));
                U.must((val2 == null || val2 instanceof Comparable ? 1 : 0) != 0, (String)"The property '%s' (%s) is not comparable!", (Object)order, (Object)Cls.of(val2));
                return sign * U.compare(val1, val2);
            }
        };
        return comparator;
    }

    public static <FROM, TO> List<TO> projection(Collection<FROM> coll, String propertyName) {
        List projection = U.list((Object[])new Object[0]);
        for (FROM item : coll) {
            projection.add(Beany.getPropValue(item, propertyName));
        }
        return projection;
    }

    public static Object unwrap(Object value) {
        return Vars.unwrap((Object)value);
    }
}

