/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.beany;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.rapidoid.beany.Beany;
import org.rapidoid.beany.Prop;
import org.rapidoid.beany.PropKind;
import org.rapidoid.util.Cls;
import org.rapidoid.util.TypeKind;
import org.rapidoid.util.U;
import org.rapidoid.var.Var;

public class BeanProp
implements Prop {
    private final String name;
    private Field field;
    private Method getter;
    private Method setter;
    private Class<?> declaringType;
    private Class<?> type;
    private Class<?> rawType;
    private TypeKind typeKind;
    private TypeKind rawTypeKind;
    private PropKind propKind = PropKind.NORMAL;
    private Object defaultValue;
    private boolean readOnly = true;
    private ParameterizedType genericType;
    private ParameterizedType rawGenericType;

    public BeanProp(String name) {
        this.name = name;
    }

    public BeanProp(String name, Field field, boolean readOnly) {
        this.name = name;
        this.field = field;
        this.readOnly = readOnly;
    }

    public void init() {
        U.must((this.field != null || this.getter != null ? 1 : 0) != 0, (String)"Invalid property: %s", (Object)this.name);
        this.rawType = this.field != null ? this.field.getType() : this.getter.getReturnType();
        this.type = this.rawType;
        Type gType = this.field != null ? this.field.getGenericType() : this.getter.getGenericReturnType();
        this.genericType = this.rawGenericType = Cls.generic((Type)gType);
        if (Collection.class.isAssignableFrom(this.type)) {
            this.readOnly = false;
            this.propKind = PropKind.COLLECTION;
        } else if (Map.class.isAssignableFrom(this.type)) {
            this.readOnly = false;
            this.propKind = PropKind.MAP;
        } else if (Var.class.isAssignableFrom(this.type)) {
            U.notNull((Object)this.genericType, (String)"generic type", (Object[])new Object[0]);
            gType = this.genericType.getActualTypeArguments()[0];
            this.genericType = Cls.generic((Type)gType);
            this.type = Cls.clazz((Type)gType);
            this.readOnly = false;
            this.propKind = PropKind.VAR;
        }
        this.typeKind = Cls.kindOf(this.type);
        this.rawTypeKind = Cls.kindOf(this.rawType);
        this.declaringType = this.field != null ? this.field.getDeclaringClass() : this.getter.getDeclaringClass();
    }

    public void setGetter(Method getter) {
        this.getter = getter;
    }

    public void setSetter(Method setter) {
        this.setter = setter;
    }

    public Method getGetter() {
        return this.getter;
    }

    public Method getSetter() {
        return this.setter;
    }

    public Field getField() {
        return this.field;
    }

    public void setField(Field field) {
        this.field = field;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    @Override
    public <T> T getRaw(Object target) {
        try {
            if (this.field != null) {
                this.field.setAccessible(true);
                return (T)this.field.get(target);
            }
            this.getter.setAccessible(true);
            return (T)this.getter.invoke(target, new Object[0]);
        }
        catch (Exception e) {
            throw U.rte((Throwable)e);
        }
    }

    @Override
    public <T> T get(Object target) {
        return (T)Beany.unwrap(this.getRaw(target));
    }

    @Override
    public void set(Object target, Object value) {
        U.must((!this.isReadOnly() ? 1 : 0) != 0, (String)"Cannot assign value to a read-only property: %s", (Object)this.name);
        value = Cls.convert((Object)value, this.getType());
        switch (this.propKind) {
            case NORMAL: {
                this.normalSet(target, value);
                break;
            }
            case COLLECTION: {
                this.collSet(target, value);
                break;
            }
            case MAP: {
                this.mapSet(target, value);
                break;
            }
            case VAR: {
                this.varSet(target, value);
                break;
            }
            default: {
                throw U.notExpected();
            }
        }
    }

    @Override
    public void reset(Object target) {
        U.must((!this.isReadOnly() ? 1 : 0) != 0, (String)"Cannot reset a read-only property: %s", (Object)this.name);
        switch (this.propKind) {
            case NORMAL: {
                if (this.type.isPrimitive()) {
                    this.primitiveReset(target);
                    break;
                }
                this.normalSet(target, null);
                break;
            }
            case COLLECTION: {
                this.collSet(target, Collections.EMPTY_LIST);
                break;
            }
            case MAP: {
                this.mapSet(target, Collections.EMPTY_MAP);
                break;
            }
            case VAR: {
                this.varSet(target, null);
                break;
            }
            default: {
                throw U.notExpected();
            }
        }
    }

    private void primitiveReset(Object target) {
        switch (this.typeKind) {
            case BOOLEAN: {
                this.normalSet(target, false);
                break;
            }
            case BYTE: {
                this.normalSet(target, (byte)0);
                break;
            }
            case SHORT: {
                this.normalSet(target, (short)0);
                break;
            }
            case CHAR: {
                this.normalSet(target, Character.valueOf('\u0000'));
                break;
            }
            case INT: {
                this.normalSet(target, 0);
                break;
            }
            case LONG: {
                this.normalSet(target, 0L);
                break;
            }
            case FLOAT: {
                this.normalSet(target, Float.valueOf(0.0f));
                break;
            }
            case DOUBLE: {
                this.normalSet(target, 0.0);
                break;
            }
            default: {
                throw U.notExpected();
            }
        }
    }

    private void varSet(Object target, Object value) {
        Var var = (Var)this.getRaw(target);
        var.set(value);
    }

    private void collSet(Object target, Object value) {
        U.must((boolean)(value instanceof Collection), (String)"Expected a collection, but found: %s", (Object)value);
        Collection coll = (Collection)this.get(target);
        if (coll == null) {
            coll = (Collection)Cls.newInstance(this.type);
        }
        coll.clear();
        coll.addAll((Collection)value);
    }

    private void mapSet(Object target, Object value) {
        U.must((boolean)(value instanceof Map), (String)"Expected a map, but found: %s", (Object)value);
        Map map = (Map)this.get(target);
        if (map == null) {
            map = (Map)Cls.newInstance(this.type);
        }
        map.clear();
        map.putAll((Map)value);
    }

    private void normalSet(Object target, Object value) {
        try {
            if (this.field != null) {
                this.field.setAccessible(true);
                this.field.set(target, value);
            } else if (this.setter != null) {
                this.setter.setAccessible(true);
                this.setter.invoke(target, value);
            } else if (this.getter != null) {
                throw U.notExpected();
            }
        }
        catch (Exception e) {
            throw U.rte((Throwable)e);
        }
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }

    @Override
    public TypeKind getTypeKind() {
        return this.typeKind;
    }

    @Override
    public ParameterizedType getGenericType() {
        return this.genericType;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Override
    public Class<?> getDeclaringType() {
        return this.declaringType;
    }

    public String toString() {
        return this.declaringType.getSimpleName() + "#" + this.name + ":" + this.type.getSimpleName();
    }

    @Override
    public int getTypeArgsCount() {
        return this.genericType != null ? this.genericType.getActualTypeArguments().length : 0;
    }

    @Override
    public Class<?> getTypeArg(int index) {
        U.bounds((int)index, (int)0, (int)(this.getTypeArgsCount() - 1));
        return Cls.clazz((Type)this.genericType.getActualTypeArguments()[index]);
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return this.field != null ? this.field.getAnnotation(annotationClass) : this.getter.getAnnotation(annotationClass);
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.field != null ? this.field.getAnnotations() : this.getter.getAnnotations();
    }

    @Override
    public Class<?> getRawType() {
        return this.rawType;
    }

    @Override
    public TypeKind getRawTypeKind() {
        return this.rawTypeKind;
    }

    @Override
    public ParameterizedType getRawGenericType() {
        return this.rawGenericType;
    }

    @Override
    public int getRawTypeArgsCount() {
        return this.rawGenericType != null ? this.rawGenericType.getActualTypeArguments().length : 0;
    }

    @Override
    public Class<?> getRawTypeArg(int index) {
        U.bounds((int)index, (int)0, (int)(this.getRawTypeArgsCount() - 1));
        return Cls.clazz((Type)this.rawGenericType.getActualTypeArguments()[index]);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.declaringType == null ? 0 : this.declaringType.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BeanProp other = (BeanProp)obj;
        if (this.declaringType == null ? other.declaringType != null : !this.declaringType.equals(other.declaringType)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

