/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.beany;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Map;
import org.rapidoid.beany.Beany;
import org.rapidoid.beany.Prop;
import org.rapidoid.cls.Cls;
import org.rapidoid.u.U;

public class Metadata {
    public static Map<Class<?>, Annotation> classAnnotations(Class<?> clazz) {
        clazz = Cls.unproxy(clazz);
        Map annotations = U.map();
        for (Annotation ann : clazz.getAnnotations()) {
            annotations.put(ann.annotationType(), ann);
        }
        return annotations;
    }

    public static <T extends Annotation> T classAnnotation(Class<?> clazz, Class<T> annotationClass) {
        clazz = Cls.unproxy(clazz);
        return (T)Metadata.classAnnotations(clazz).get(annotationClass);
    }

    public static Map<Class<?>, Annotation> methodAnnotations(Method method) {
        Map annotations = U.map();
        for (Annotation ann : method.getAnnotations()) {
            annotations.put(ann.annotationType(), ann);
        }
        return annotations;
    }

    public static <T extends Annotation> T methodAnnotation(Method method, Class<T> annotationClass) {
        return (T)Metadata.methodAnnotations(method).get(annotationClass);
    }

    public static Map<Class<?>, Annotation> propAnnotations(Class<?> clazz, String property) {
        clazz = Cls.unproxy(clazz);
        Map annotations = U.map();
        Prop prop = Beany.property(clazz, property, false);
        if (prop != null) {
            for (Annotation ann : prop.getDeclaringType().getAnnotations()) {
                annotations.put(ann.annotationType(), ann);
            }
            for (Annotation ann : prop.getAnnotations()) {
                annotations.put(ann.annotationType(), ann);
            }
        }
        return annotations;
    }

    public static <T extends Annotation> T propAnnotation(Class<?> clazz, String property, Class<T> annotationClass) {
        clazz = Cls.unproxy(clazz);
        return (T)Metadata.propAnnotations(clazz, property).get(annotationClass);
    }

    public static boolean isAnnotated(Class<?> clazz, Class<?> annotation) {
        clazz = Cls.unproxy(clazz);
        return Metadata.classAnnotations(clazz).containsKey(annotation);
    }

    public static <T extends Annotation> T get(Annotation[] annotations, Class<T> annotationClass) {
        if (annotations != null) {
            for (Annotation ann : annotations) {
                if (!annotationClass.isAssignableFrom(ann.annotationType())) continue;
                return (T)ann;
            }
        }
        return null;
    }
}

