/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.crypto;

import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.rapidoid.config.Conf;
import org.rapidoid.util.U;

public class Crypto {
    public static MessageDigest digest(String algorithm) {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw U.rte((String)("Cannot find crypto algorithm: " + algorithm));
        }
    }

    public static Cipher cipher(String transformation) {
        try {
            return Cipher.getInstance(transformation);
        }
        catch (NoSuchAlgorithmException e) {
            throw U.rte((String)("Cannot find crypto algorithm: " + transformation));
        }
        catch (NoSuchPaddingException e) {
            throw U.rte((String)("No such padding: " + transformation));
        }
    }

    public static byte[] md5Bytes(byte[] bytes) {
        MessageDigest md5 = Crypto.digest("MD5");
        md5.update(bytes);
        return md5.digest();
    }

    public static String md5(byte[] bytes) {
        return U.bytesAsText((byte[])Crypto.md5Bytes(bytes));
    }

    public static String md5(String data) {
        return Crypto.md5(data.getBytes());
    }

    public static byte[] sha1Bytes(byte[] bytes) {
        MessageDigest sha1 = Crypto.digest("SHA-1");
        sha1.update(bytes);
        return sha1.digest();
    }

    public static String sha1(byte[] bytes) {
        return U.bytesAsText((byte[])Crypto.sha1Bytes(bytes));
    }

    public static String sha1(String data) {
        return Crypto.sha1(data.getBytes());
    }

    public static byte[] sha512Bytes(byte[] bytes) {
        MessageDigest sha1 = Crypto.digest("SHA-512");
        sha1.update(bytes);
        return sha1.digest();
    }

    public static String sha512(byte[] bytes) {
        return U.bytesAsText((byte[])Crypto.sha512Bytes(bytes));
    }

    public static String sha512(String data) {
        return Crypto.sha512(data.getBytes());
    }

    public static synchronized String secret() {
        String secret = Conf.secret();
        if (secret == null) {
            if (Conf.dev()) {
                secret = "";
            } else {
                throw U.rte((String)"Application secret must be specified!");
            }
        }
        return secret;
    }

    public static byte[] aes(byte[] key, byte[] data, boolean encrypt) {
        byte[] enc;
        Cipher cipher = Crypto.cipher("AES");
        SecretKeySpec secretKey = new SecretKeySpec(key, "AES");
        try {
            cipher.init(encrypt ? 1 : 2, secretKey);
        }
        catch (InvalidKeyException e) {
            throw U.rte((String)"Invalid key for the cypher!");
        }
        try {
            enc = cipher.doFinal(data);
        }
        catch (IllegalBlockSizeException e) {
            throw U.rte((String)"Illegal block size!");
        }
        catch (BadPaddingException e) {
            throw U.rte((String)"Bad padding!");
        }
        return enc;
    }

    public static byte[] encrypt(String secret, byte[] dataToEncrypt) {
        byte[] key = Crypto.md5Bytes(secret.getBytes());
        return Crypto.aes(key, dataToEncrypt, true);
    }

    public static byte[] decrypt(String secret, byte[] dataToDecrypt) {
        byte[] key = Crypto.md5Bytes(secret.getBytes());
        return Crypto.aes(key, dataToDecrypt, false);
    }

    public static byte[] encrypt(byte[] dataToEncrypt) {
        return Crypto.encrypt(Crypto.secret(), dataToEncrypt);
    }

    public static byte[] decrypt(byte[] dataToDecrypt) {
        return Crypto.decrypt(Crypto.secret(), dataToDecrypt);
    }
}

