/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.jackson;

import com.fasterxml.jackson.core.Base64Variants;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.module.afterburner.AfterburnerModule;
import java.io.OutputStream;
import java.util.Map;

public class YAML {
    public static final ObjectMapper MAPPER = YAML.mapper();

    private static ObjectMapper mapper() {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        mapper.setBase64Variant(Base64Variants.MODIFIED_FOR_URL);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.registerModule((Module)new AfterburnerModule());
        return mapper;
    }

    public static String stringify(Object value) {
        try {
            return MAPPER.writeValueAsString(value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void stringify(Object value, OutputStream out) {
        try {
            MAPPER.writeValue(out, value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T parse(String yaml, Class<T> valueType) {
        try {
            return (T)MAPPER.readValue(yaml, valueType);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T parse(byte[] yaml, Class<T> valueType) {
        try {
            return (T)MAPPER.readValue(yaml, valueType);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T parse(String yaml, TypeReference<T> valueType) {
        try {
            return (T)MAPPER.readValue(yaml, valueType);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T parse(byte[] yaml, TypeReference<T> valueType) {
        try {
            return (T)MAPPER.readValue(yaml, valueType);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Map<String, Object> parseMap(String yaml) {
        return YAML.parse(yaml, Map.class);
    }
}

